% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNP.eq.R
\name{BNP.eq.predict}
\alias{BNP.eq.predict}
\title{Prediction step for Bayesian non-parametric model for test equating}
\description{
This function implements the prediction step in the Bayesian non-parametric model for test equating
}
\usage{
BNP.eq.predict(model, from = NULL, into = NULL, alpha = 0.05)
}
\arguments{
\item{model}{A 'BNP.eq' object.}

\item{from}{Numeric. A vector of indices indicating from which patterns equating should be performed.
The covariates involved are integrated out.}

\item{into}{Numeric. A vector of indices indicating into which patterns equating should be performed.
The covariates involved are integrated out.}

\item{alpha}{Numeric. Level of significance for credible bands.}
}
\value{
A 'BNP.eq.predict' object, which is a list containing the following items:

pdf A list of PDF's.

cdf A list of CDF's.

equ Numeric. Equated values.

grid Numeric. Grid used to evaluate pdf's and cdf's.
}

\details{
Predictions of the score probability distributions are obtained under the Bayesian nonparametric 
model and are used to compute the equating function.   
}
\author{
Daniel Leon \email{dnacuna@uc.cl}, Felipe Barrientos \email{afb26@stat.duke.edu}.
}
\references{
Gonzalez, J., Barrientos, A., and Quintana, F. (2015). Bayesian Nonparametric Estimation of Test Equating Functions with Covariates. \emph{Computational Statistics and Data Analysis, 89,} 222-244.
}
\keyword{nonparametric}
\concept{Bayesian}
\concept{equating}

