% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoffs.R
\name{SNPknock.knockoffHaplotypes}
\alias{SNPknock.knockoffHaplotypes}
\title{Knockoff copies of phased haplotypes}
\usage{
SNPknock.knockoffHaplotypes(X, r, alpha, theta, seed = 123, cluster = NULL,
  display_progress = TRUE)
}
\arguments{
\item{X}{a binary matrix of size n-by-p containing the original variables.}

\item{r}{a vector of length p containing the "r" parameters estimated by fastPHASE.}

\item{alpha}{a matrix of size p-by-K containing the "alpha" parameters estimated by fastPHASE.}

\item{theta}{a matrix of size p-by-K containing the "theta" parameters estimated by fastPHASE.}

\item{seed}{an integer random seed (default: 123).}

\item{cluster}{a computing cluster object created by \link[parallel]{makeCluster} (default: NULL).}

\item{display_progress}{whether to show progress bar (default: TRUE).}
}
\value{
A binary matrix of size n-by-p containing the knockoff variables.
}
\description{
This function efficiently constructs knockoff copies of binary variables distributed 
according to the Li and Stephens model for phased haplotypes.
}
\details{
Generate knockoff copies of phased haplotypes according to the Li and Stephens HMM.
The required model parameters can be obtained through fastPHASE and loaded with \link{SNPknock.fp.loadFit}.
This function is more efficient than \link{SNPknock.knockoffHMM} for haplotype data.
}
\examples{
# Load an example dataset of phased haplotypes from the package installation directory.
H_file = system.file("extdata", "haplotypes.RData", package = "SNPknock")
load(H_file)

# Specify the location of the fastPHASE output files containing the parameter estimates.
# Example files can be found in the package installation directory.
r_file = system.file("extdata", "haplotypes_rhat.txt", package = "SNPknock")
theta_file = system.file("extdata", "haplotypes_thetahat.txt", package = "SNPknock")
alpha_file = system.file("extdata", "haplotypes_alphahat.txt", package = "SNPknock")
char_file = system.file("extdata", "haplotypes_origchars", package = "SNPknock")

# Read the parameter files and build the HMM
hmm = SNPknock.fp.loadFit(r_file, theta_file, alpha_file, char_file)

# Generate the knockoffs
Hk = SNPknock.knockoffHaplotypes(H, hmm$r, hmm$alpha, hmm$theta)

}
\references{
Sesia et al., Gene Hunting with Knockoffs for Hidden Markov Models,
  arXiv:1706.04677 (2017).
  \href{https://statweb.stanford.edu/~candes/papers/HMM_Knockoffs.pdf}{https://statweb.stanford.edu/~candes/papers/HMM_Knockoffs.pdf}

Scheet and Stephens,  A fast and flexible statistical model for large-scale population genotype data,
  Am J Hum Genet (2006).
  \href{http://www.sciencedirect.com/science/article/pii/S000292970763701X}{http://www.sciencedirect.com/science/article/pii/S000292970763701X}
}
\seealso{
Other knockoffs: \code{\link{SNPknock.knockoffDMC}},
  \code{\link{SNPknock.knockoffGenotypes}},
  \code{\link{SNPknock.knockoffHMM}}
}
