% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/S3_BalancedAccuracy.R
\name{baccuracy.factor}
\alias{baccuracy.factor}
\alias{weighted.baccuracy.factor}
\alias{baccuracy.cmatrix}
\alias{baccuracy}
\alias{weighted.baccuracy}
\title{Balanced Accuracy}
\usage{
\method{baccuracy}{factor}(actual, predicted, adjust = FALSE, na.rm = TRUE, ...)

\method{weighted.baccuracy}{factor}(actual, predicted, w, adjust = FALSE, na.rm = TRUE, ...)

\method{baccuracy}{cmatrix}(x, adjust = FALSE, na.rm = TRUE, ...)

## Generic S3 method
baccuracy(
  ...,
  adjust = FALSE,
  na.rm  = TRUE
)

## Generic S3 method
weighted.baccuracy(
  ...,
  w,
  adjust = FALSE,
  na.rm  = TRUE
)
}
\arguments{
\item{actual}{A vector of <\link{factor}> with \link{length} \eqn{n}, and \eqn{k} levels}

\item{predicted}{A vector of <\link{factor}> with \link{length} \eqn{n}, and \eqn{k} levels}

\item{adjust}{A \link{logical} value (default: \link{FALSE}). If \link{TRUE} the metric is adjusted for random chance \eqn{\frac{1}{k}}.}

\item{na.rm}{A \link{logical} value (default: \link{TRUE}).  If \link{TRUE} calculation of the metric is based on valid classes.}

\item{...}{Arguments passed into other methods}

\item{w}{A <\link{numeric}>-vector of \link{length} \eqn{n}. \link{NULL} by default}

\item{x}{A confusion matrix created \code{\link[=cmatrix]{cmatrix()}}}
}
\value{
A \link{numeric}-vector of \link{length} 1
}
\description{
A generic function for the (normalized) balanced \href{https://arxiv.org/abs/2008.05756}{accuracy}.
Use \code{\link[=weighted.baccuracy]{weighted.baccuracy()}} for the weighted balanced \href{https://arxiv.org/abs/2008.05756}{accuracy}.
}
\section{Definition}{

Let \eqn{\hat{\alpha} \in [0, 1]} be the proportion of correctly predicted classes. If \code{adjust == false}, the balanced \href{https://arxiv.org/abs/2008.05756}{accuracy} of the classifier is calculated as,

\deqn{
  \hat{\alpha} = \frac{\text{sensitivity} + \text{specificity}}{2}
}

otherwise,

\deqn{
  \hat{\alpha} = \frac{\text{sensitivity} + \text{specificity}}{2} \frac{1}{k}
}

Where:
\itemize{
\item \eqn{k} is the number of classes
\item \eqn{\text{sensitivity}} is the overall \href{https://developers.google.com/machine-learning/crash-course/classification/accuracy-precision-recall#recall_or_true_positive_rate}{sensitivity}, and
\item \eqn{\text{specificity}} is the overall \href{https://developers.google.com/machine-learning/crash-course/classification/accuracy-precision-recall#recall_or_true_positive_rate}{specificity}
}
}

\section{Creating <\link{factor}>}{


Consider a classification problem with three classes: \code{A}, \code{B}, and \code{C}. The actual vector of \code{\link[=factor]{factor()}} values is defined as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## set seed
set.seed(1903)

## actual
factor(
  x = sample(x = 1:3, size = 10, replace = TRUE),
  levels = c(1, 2, 3),
  labels = c("A", "B", "C")
)
#>  [1] B A B B A C B C C A
#> Levels: A B C
}\if{html}{\out{</div>}}

Here, the values 1, 2, and 3 are mapped to \code{A}, \code{B}, and \code{C}, respectively. Now, suppose your model does not predict any \code{B}'s. The predicted vector of \code{\link[=factor]{factor()}} values would be defined as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## set seed
set.seed(1903)

## predicted
factor(
  x = sample(x = c(1, 3), size = 10, replace = TRUE),
  levels = c(1, 2, 3),
  labels = c("A", "B", "C")
)
#>  [1] C A C C C C C C A C
#> Levels: A B C
}\if{html}{\out{</div>}}

In both cases, \eqn{k = 3}, determined indirectly by the \code{levels} argument.
}

\examples{
# 1) recode Iris
# to binary classification
# problem
iris$species_num <- as.numeric(
  iris$Species == "virginica"
)

# 2) fit the logistic
# regression
model <- glm(
  formula = species_num ~ Sepal.Length + Sepal.Width,
  data    = iris,
  family  = binomial(
    link = "logit"
  )
)

# 3) generate predicted
# classes
predicted <- factor(
  as.numeric(
    predict(model, type = "response") > 0.5
  ),
  levels = c(1,0),
  labels = c("Virginica", "Others")
)

# 3.1) generate actual
# classes
actual <- factor(
  x = iris$species_num,
  levels = c(1,0),
  labels = c("Virginica", "Others")
)

# 4) evaluate the
# model
cat(
  "Balanced accuracy", baccuracy(
    actual    = actual,
    predicted = predicted
  ),
  
  "Balanced accuracy (weigthed)", weighted.baccuracy(
    actual    = actual,
    predicted = predicted,
    w         = iris$Petal.Length/mean(iris$Petal.Length)
  ),
  sep = "\n"
)
}
\seealso{
Other Classification: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fmi.factor}()},
\code{\link{fpr.factor}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mcc.factor}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{recall.factor}()},
\code{\link{roc.auc.matrix}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}

Other Supervised Learning: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{ccc.numeric}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fpr.factor}()},
\code{\link{huberloss.numeric}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mcc.factor}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{pinball.numeric}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{rae.numeric}()},
\code{\link{recall.factor}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{roc.auc.matrix}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}
}
\concept{Classification}
\concept{Supervised Learning}
