% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLICER.R
\name{compute_geodesic_entropy}
\alias{compute_geodesic_entropy}
\title{Compute the geodesic entropy profile of a trajectory}
\usage{
compute_geodesic_entropy(traj_graph, start)
}
\arguments{
\item{traj_graph}{Nearest neighbor graph built from LLE embedding}

\item{start}{Index of start cell}
}
\value{
Vector of geodesic entropy values. Item k is the
geodesic entropy k steps away from the start cell.
}
\description{
The geodesic entropy of a trajectory can be used to detect
branches. This function computes geodesic entropy and
produces a plot that can be used to visually confirm
the branches detected by \code{assign_branches}.
}
\examples{
\dontrun{
traj_lle = lle(traj[,genes],m=2,k)$Y
traj_graph = conn_knn_graph(traj_lle,5)
start=1
compute_geodesic_entropy(traj_graph,start)
}
}
