% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StG.R
\name{STG}
\alias{STG}
\title{Wrapper function for the SIRItoGTFS library}
\usage{
STG(SIRIDF, GTFSstops., GTFSagency., GTFScalendar., GTFSroutes.,
  GTFSstop_times., GTFStrips., linerefs = NULL, epsg = 2039)
}
\arguments{
\item{SIRIDF}{A \code{\link[base]{data.frame}} containing SIRI protocol data downloaded from a public transportation authority.}

\item{GTFSstops.}{A GTFS stops table, best load into environment with \code{\link{readGTFS}}}

\item{GTFSagency.}{A GTFS agency table, best load into environment with \code{\link{readGTFS}}}

\item{GTFScalendar.}{A GTFS calendar table, best load into environment with \code{\link{readGTFS}}}

\item{GTFSroutes.}{A GTFS routes table, best load into environment with \code{\link{readGTFS}}}

\item{GTFSstop_times.}{A GTFS stop_times table, best load into environment with \code{\link{readGTFS}}}

\item{GTFStrips.}{A GTFS trips table, best load into environment with \code{\link{readGTFS}}}

\item{linerefs}{Optional, a numeric vector of GTFS route_id numbers to process. if not used all route_id's in the SIRIDF provided will be used.}

\item{epsg}{The EPSG code for the projection to be used.}
}
\value{
A \code{\link[base]{data.frame}} containing a comparison between a public transportation mode's schedule and real-time data.
}
\description{
Performs a comparison between a SIRI data.frame and GTFS tables,
requires the SIRI table  as well as the minimal GTFS tables to be in the environment.
should be used after \code{\link{readGTFS}}.
}
\details{
The function provides an "easy to use" wrapper for users unfamiliar with the functions in **SIRItoGTFS**.
It should be used after a SIRI table has been read into R's environment along with GTFS tables who have a corresponding date.
it is best used after \code{\link{readGTFS}}.
the SIRI table used should have the minimal columns:
"RecordedAtTime", "MonitoringRef", "LineRef", "DirectionRef", "PublishedLineName",
"OperatorRef", "DestinationRef", "OriginAimedDepartureTime", "Longitude",
"Latitude", "VehicleRef", "StopPointRef" & "ExpectedArrivalTime".
The output table will contain a time and distance comparison between the schedule provided in the GTFS tables and the real-time data provided
with the SIRI table.
}
\examples{
require(SIRItoGTFS)
require(data.table)
# use the sample SIRI data included with the package
SIRIDF = SIRIsample
# load your own GTFS data with `readGTFS()`
# or use the subset of GTFS data conformable to the SIRI sample, also included in the package
data("GTFSstops")
data("GTFSstop_times")
data("GTFScalendar")
data("GTFStrips")
data("GTFSagency")
data("GTFSroutes")
busesDF = STG(SIRIDF,
              GTFSstops. = GTFSstops,
              GTFSagency. = GTFSagency,
              GTFScalendar. = GTFScalendar,
              GTFSroutes. = GTFSroutes,
              GTFSstop_times. = GTFSstop_times,
              GTFStrips. = GTFStrips,
              linerefs = unique(SIRIDF$lineref[1]))

}
\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Estimation of public transport service reliability using Big Data and open source tools}
}
\seealso{
\code{readGTFS}
}
\keyword{package}
\keyword{spatial}
