% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getCsdAlleles}
\alias{getCsdAlleles}
\alias{getQueenCsdAlleles}
\alias{getFathersCsdAlleles}
\alias{getVirginQueensCsdAlleles}
\alias{getWorkersCsdAlleles}
\alias{getDronesCsdAlleles}
\title{Get csd alleles}
\usage{
getCsdAlleles(
  x,
  caste = NULL,
  nInd = NULL,
  allele = "all",
  dronesHaploid = TRUE,
  collapse = FALSE,
  unique = FALSE,
  simParamBee = NULL
)

getQueenCsdAlleles(
  x,
  allele = "all",
  unique = FALSE,
  collapse = FALSE,
  simParamBee = NULL
)

getFathersCsdAlleles(
  x,
  nInd = NULL,
  allele = "all",
  dronesHaploid = TRUE,
  unique = FALSE,
  collapse = FALSE,
  simParamBee = NULL
)

getVirginQueensCsdAlleles(
  x,
  nInd = NULL,
  allele = "all",
  unique = FALSE,
  collapse = FALSE,
  simParamBee = NULL
)

getWorkersCsdAlleles(
  x,
  nInd = NULL,
  allele = "all",
  unique = FALSE,
  collapse = FALSE,
  simParamBee = NULL
)

getDronesCsdAlleles(
  x,
  nInd = NULL,
  allele = "all",
  dronesHaploid = TRUE,
  unique = FALSE,
  collapse = FALSE,
  simParamBee = NULL
)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, \code{\link[SIMplyBee]{Colony-class}}, or
\code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link[AlphaSimR]{Pop-class}},
and character when \code{x} is a \code{\link[SIMplyBee]{Colony-class}} or
 \code{\link[SIMplyBee]{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, for how many individuals; if \code{NULL} all individuals
are taken; this can be useful as a test of sampling individuals}

\item{allele}{character, either "all" for both alleles or an integer for a
single allele, use a value of 1 for female allele and a value of 2 for male
allele}

\item{dronesHaploid}{logical, return haploid result for drones?}

\item{collapse}{logical, if \code{TRUE}, the function will return a set of
csd alleles across the entire population, colony, or multicolony (not
separately for each caste when \code{x} is a colony or each caste of
each colony when \code{x} is a multicolony. This is a way to get one single
object as an output across castes or colonies. Note this has nothing to do
with the colony collapse. It's like \code{paste(..., collapse = TRUE)}.
Default is \code{FALSE}. See examples about this behaviour.}

\item{unique}{logical, return only the unique set of csd alleles. This argument
interacts with \code{collapse}. Default is \code{FALSE}. See examples about
this behaviour.}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
matrix with haplotypes when \code{x} is \code{\link[AlphaSimR]{Pop-class}}, list
  of matrices with haplotypes when \code{x} is \code{\link[SIMplyBee]{Colony-class}}
  (list nodes named by caste) and list of a list of matrices with haplotypes
  when \code{x} is \code{\link[SIMplyBee]{MultiColony-class}}, outer list is named by
  colony id when \code{x} is \code{\link[SIMplyBee]{MultiColony-class}}; \code{NULL} when
  \code{x} is \code{NULL}
}
\description{
Level 0 function that returns alleles from the csd locus. See
  \code{\link[SIMplyBee]{SimParamBee}} for more information about the csd locus.
}
\details{
If both collapse and unique are \code{TRUE}, the function returns a
  unique set of csd alleles in the entire population, colony, or multicolony
}
\section{Functions}{
\itemize{
\item \code{getQueenCsdAlleles()}: Access csd alleles of the queen

\item \code{getFathersCsdAlleles()}: Access csd alleles of the fathers

\item \code{getVirginQueensCsdAlleles()}: Access csd alleles of the virgin queens

\item \code{getWorkersCsdAlleles()}: Access csd alleles of the workers

\item \code{getDronesCsdAlleles()}: Access csd alleles of the drones

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes, nCsdAlleles = 5)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)

# Use getCsdAlleles on a Population
getCsdAlleles(getQueen(colony))
getCsdAlleles(getWorkers(colony))

# Use getCsdAlleles on a Colony
getCsdAlleles(colony)
getCsdAlleles(colony, caste = "queen")
getQueenCsdAlleles(colony)
getCsdAlleles(colony, caste = "workers")
getWorkersCsdAlleles(colony)
# Same aliases exist for all the castes!

getCsdAlleles(colony, unique = TRUE)
getCsdAlleles(colony, collapse = TRUE)
getCsdAlleles(colony, collapse = TRUE, unique = TRUE)

# Use getCsdAlleles on a MultiColony
getCsdAlleles(apiary)
getCsdAlleles(apiary, unique = TRUE)
getCsdAlleles(apiary, collapse = TRUE, unique = TRUE)
getCsdAlleles(apiary, nInd = 2)
}
