% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupMetricsML.R
\name{groupMetricsML}
\alias{groupMetricsML}
\title{Calculate maximum likelihood based measures of dispersion of bivariate data}
\usage{
groupMetricsML(siber)
}
\arguments{
\item{siber}{a siber object as created by createSiberObject.}
}
\value{
A 3 x m matrix of the 6 Layman metrics of dX_range, dY_range, TA,
CD, MNND and SDNND in rows, where each column is a different group nested
within a community.
}
\description{
This function loops over each group within each community and calculates the
convex hull total area, Standard Ellipse Area (SEA) and its corresponding
small sample size corrected version SEAc based on the maximum likelihood
estimates of the means and covariance matrices of each group.
}
\examples{
data(demo.siber.data)
my.siber.data <- createSiberObject(demo.siber.data)
groupMetricsML(my.siber.data)

}
