% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.usek1d.R
\name{usek1d}
\alias{usek1d}
\title{Apply k-sample tests for two univariate samples}
\usage{
usek1d(x, y, test.name, ...)
}
\arguments{
\item{x}{a length-\eqn{n} data vector.}

\item{y}{a length-\eqn{m} data vector.}

\item{test.name}{character string for the name of k-sample test to be used.}

\item{...}{extra arguments passed onto the function \code{test.name}.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Any \eqn{k}-sample method implies that it can be used for 
a special case of \eqn{k=2}. \code{usek1d} lets any \eqn{k}-sample tests 
provided in this package be used with two univariate samples \eqn{x} and \eqn{y}.
}
\examples{
\donttest{
### compare two-means via anova and t-test
### since they coincide when k=2
x = rnorm(50)
y = rnorm(50)

### run anova and t-test
test1 = usek1d(x, y, "meank.anova")
test2 = mean2.ttest(x,y)

## print the result
cat(paste("\n* Comparison of ANOVA and t-test \n","*\n",
"* p-value from ANOVA  : ", round(test1$p.value,5),"\n",
"*              t-test : ", round(test2$p.value,5),"\n",sep=""))
}

}
\concept{utility}
