% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean2.2014CLX.R
\name{mean2.2014CLX}
\alias{mean2.2014CLX}
\title{Two-sample Test for High-Dimensional Means by Cai, Liu, and Xia (2014)}
\usage{
mean2.2014CLX(X, Y, Omega = NULL, cov.equal = TRUE)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{Omega}{precision matrix; if \code{NULL}, it applies CLIME estimation. Otherwise, 
a \eqn{(p\times p)} inverse covariance should be provided.}

\item{cov.equal}{a logical to determine homogeneous covariance assumption.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two multivariate data \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : \mu_x = \mu_y\quad vs\quad H_1 : \mu_x \neq \mu_y}
using the procedure by Cai, Liu, and Xia (2014). Since the test is equivalent to testing 
\deqn{H_0 : \Omega(\mu_x - \mu_y)=0},
if \eqn{\Omega}, an inverse covariance (or precision), is not provided, it finds 
a sparse precision matrix via CLIME estimator. Also, if two samples 
are assumed to have different covariance structure, it uses weighting scheme for adjustment.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
smallY = matrix(rnorm(10*3),ncol=3)
mean2.2014CLX(smallX, smallY) # run the test

\donttest{
## empirical Type 1 error 
niter   = 100
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(50*5), ncol=50)
  Y = matrix(rnorm(50*5), ncol=50)
  
  counter[i] = ifelse(mean2.2014CLX(X, Y)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\\n* Example for 'mean2.2014CLX'\\n\\n",
sprintf("* number of rejections   : \%d\\n",sum(counter)),
sprintf("* total number of trials : \%d\\n",niter),
sprintf("* empirical Type 1 error : \%.4f\\n", sum(counter/niter)),sep=""))
}

}
\references{
\insertRef{cai_two-sample_2014}{SHT}
}
