% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicitDirichlet.R
\name{fitDirichlet}
\alias{fitDirichlet}
\title{Fit a Dirichlet distribution to elicited marginal distributions for proportions}
\usage{
fitDirichlet(..., categories = NULL, n.fitted = "opt", plotBeta = TRUE)
}
\arguments{
\item{...}{A list of objects of class \code{elicitation}.
command, one per marginal proportion, separated by commas.}

\item{categories}{A vector of strings labelling the marginal proportions.}

\item{n.fitted}{The method used to determine the sum of the Dirichlet parameters.
Use \code{"opt"} for best fitting, derived by matching standard deviations from the elicited marginals
and the fitted Dirichlet; \code{"min"} for a conservative choice based 
on the smallest equivalent sample size (sum of the beta parameters) from the 
elicited marginals; \code{"med"} for the mean of the smallest and largest largest equivalent sample size
from the 
elicited marginals; \code{"mean"} for the mean of all the equivalent sample sizes
from the 
elicited marginals.}

\item{plotBeta}{logical. Plot the original elicited marginals and the fitted marginals from the 
Dirichlet fit.}
}
\value{
The parameters of the fitted Dirichlet distribution.
}
\description{
Takes elicited beta distributions for a set of proportions as inputs,
and fits a Dirichlet distribution. The beta parameters are adjusted 
so that the expectations sum to 1, and then the sum of the Dirichlet
parameters is chosen based on the sums of the beta parameters for each elicited marginal
}
\examples{
\dontrun{
p1 <- c(0.25, 0.5, 0.75)
v1 <- c(0.5, 0.55, 0.6)
v2 <- c(0.22, 0.3, 0.35)
v3 <- c(0.11, 0.15, 0.2)
myfit1 <- fitdist(v1, p1, 0, 1)
myfit2 <- fitdist(v2, p1, 0, 1)
myfit3 <- fitdist(v3, p1, 0, 1)
d <- fitDirichlet(myfit1, myfit2, myfit3,
                  categories = c("A","B","C"),
                  n.fitted = "opt")
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
\references{
Zapata-Vazquez, R., O'Hagan, A. and Bastos, L. S. (2014). Eliciting expert judgements about a set of proportions. Journal of Applied Statistics 41, 1919-1933.
}

