
\name{Reading and combining SGP outputs}
\alias{read_SGP}
\alias{read_summary}
\title{Read and combine SGP outputs}
\usage{
read_SGP(path = ".", type = NULL,
         file.ext = ".RData", verbose = TRUE)

read_summary(path = ".", type = NULL,
             file.ext = ".RData", verbose = TRUE)
}
\arguments{
\item{path}{(character) Path where output files were saved. This may include a prefix}

\item{type}{(character) Either 'SGP' or 'SGP.CV' to collect results generated by either function of the same name}

\item{file.ext}{(character) This is the file extension at which file was saved as per the argument \code{save.at}}

\item{verbose}{\code{TRUE} or \code{FALSE} to whether printing details}
}
\value{
An object of the class 'SGP' for which methods \code{predict}, \code{plot} and \code{summary} exist
}
\description{
Read the output generated by the 'SGP' or 'SGP.CV' functions saved at the provided \code{save.at} parameter. It merges all partial files when data was splited according to argument \code{subset}. Function 'read_summary' reads the output generated after calling the method \code{summary}; multiple outputs are read if argument \code{path} is a vector and in this case, they are combined by averaging across all outputs.
}
\examples{
  require(SFSI)
  data(wheatHTP)
  
  index = which(Y$trial \%in\% 1:10)    # Use only a subset of data
  Y = Y[index,]
  M = scale(M[index,])/sqrt(ncol(M))  # Subset and scale markers
  G = tcrossprod(M)                   # Genomic relationship matrix
  y = as.vector(scale(Y[,"E1"]))      # Scale response variable
  
  # Training and testing sets
  tst = which(Y$trial \%in\% 1:3)
  trn = seq_along(y)[-tst]
  
  path = paste0(tempdir(),"/testSGP_")
  
  # Run the analysis into 4 subsets and save them at a given path
  SGP(y, K=G, trn=trn, tst=tst, subset=c(1,4), save.at=path)
  SGP(y, K=G, trn=trn, tst=tst, subset=c(2,4), save.at=path)
  SGP(y, K=G, trn=trn, tst=tst, subset=c(3,4), save.at=path)
  SGP(y, K=G, trn=trn, tst=tst, subset=c(4,4), save.at=path)

  # Collect all results after completion
  fm = read_SGP(path)
  
  # Generate and save summary 
  summary(fm, save.at=path)
  fm2 = read_summary(path)
}

