% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semCluster.R
\name{clusterScore}
\alias{clusterScore}
\title{Module scoring}
\usage{
clusterScore(
  graph,
  data,
  group,
  HM = "LV",
  type = "wtc",
  size = 5,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{graph}{An igraph object.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes.}

\item{group}{A binary vector. This vector must be as long as the number
of subjects. Each vector element must be 1 for cases and 0 for control
subjects.}

\item{HM}{Hidden model type. For each defined hidden module:
(i) if \code{HM = "LV"}, a latent variable (LV) will be defined as
common unknown cause acting on cluster nodes; (ii) if \code{HM = "CV"},
cluster nodes will be considered as regressors of a latent composite
variable (CV); (iii) if \code{HM = "UV"}, an unmeasured variable (UV)
model will be generated for each module, where source nodes (i.e.,
in-degree = 0) act as common regressors influencing the other nodes
via an unmeasured variable.
By default, HM is set to "LV" (i.e., the latent variable model).}

\item{type}{Graph clustering method. If \code{type = "tahc"}, network
modules are generated using the tree agglomerative hierarchical
clustering method (Yu et al., 2015).
Other non-tree clustering methods from igraph package include: "wtc"
(default value; walktrap community structure with short random walks),
"ebc" (edge betweenness clustering), "fgc" (fast greedy method), "lbc"
(label propagation method), "lec" (leading eigenvector method), "loc"
(multi-level optimization), "opc" (optimal communiy structure), "sgc"
(spinglass statistical mechanics).
By default, the "wtc" method is used.}

\item{size}{Minimum number of nodes per hidden module. By default, a
minimum number of 5 nodes is required.}

\item{verbose}{A logical value. If TRUE, intermediate graphs will be
displayed during the execution. In addition, a reduced graph with
clusters as nodes will be fitted and showed to screen (see also
\code{\link[SEMgraph]{mergeNodes}}). By default, \code{verbode = FALSE}.}

\item{...}{Currently ignored.}
}
\value{
A list of 3 objects:
\enumerate{
\item "fit", hidden module fitting as a lavaan object;
\item "membership", hidden module nodes membership;
\code{\link[SEMgraph]{clusterGraph}} function;
\item "dataHM", data matrix with cluster scores in first columns.
}
}
\description{
Generate factor scores, principal component scores, or
projection scores of latent, composite, and unmeasured variable modules,
respectively, and fit them with an exogenous group effect.
}
\examples{

library(huge)
als.npn <- huge.npn(alsData$exprs)

C <- clusterScore(graph = alsData$graph, data = als.npn,
                  group = alsData$group,
                  HM = "LV",
                  type = "wtc",
                  verbose = FALSE)
summary(C$fit)
head(C$dataHM)
table(C$membership)

}
\references{
Grassi M, Palluzzi F, Tarantino B (2022). SEMgraph: An R Package for Causal Network
Analysis of High-Throughput Data with Structural Equation Models.
Bioinformatics, 2022;, btac567, https://doi.org/10.1093/bioinformatics/btac567
}
\seealso{
See \code{\link[SEMgraph]{clusterGraph}} and \code{\link[SEMgraph]{cplot}}
for graph clustering, and \code{\link[cate]{factor.analysis}} for
factor analysis.
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
