% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{properties}
\alias{properties}
\title{Graph properties summary and graph decomposition}
\usage{
properties(graph, data = NULL, ...)
}
\arguments{
\item{graph}{Input network as an igraph object.}

\item{data}{An optional data matrix whith rows corresponding to subjects,
and columns to graph nodes (variables). Nodes will be mapped onto
variable names.}

\item{...}{Currently ignored.}
}
\value{
List of graph components, ordered by decreasing size (the first
component is the giant one), without self-loops.
}
\description{
Produces a summary of network properties and returns
graph components (ordered by decreasing size), without self-loops.
}
\examples{

# Extract from graphite the "Steroid biosynthesis" pathway:

library(graphite)
humanKegg <- pathways("hsapiens", "kegg")
p <- humanKegg[["Steroid biosynthesis"]]
g <- pathwayGraph(p)
graph::nodes(g) <- gsub("ENTREZID:","",graph::nodes(g))

properties(graph_from_graphnel(g))

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
