% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMml.R
\name{predict.ML}
\alias{predict.ML}
\title{SEM-based out-of-sample prediction using node-wise ML}
\usage{
\method{predict}{ML}(object, newdata, newoutcome = NULL, ncores = 2, verbose = FALSE, ...)
}
\arguments{
\item{object}{A model fitting object from \code{SEMml()} function.}

\item{newdata}{A matrix containing new data with rows corresponding to subjects,
and columns to variables.}

\item{newoutcome}{A new character vector (as.factor) of labels for a categorical
output (target)(default = NULL).}

\item{ncores}{number of cpu cores (default = 2)}

\item{verbose}{Print predicted out-of-sample MSE values (default = FALSE).}

\item{...}{Currently ignored.}
}
\value{
A list of 3 objects:
\enumerate{
\item "PE", vector of the amse = average MSE over all (sink and mediators)
graph nodes; r2 = 1 - amse; and srmr= Standardized Root Means Squared Residual
between the out-of-bag correlation matrix and the model correlation matrix.
\item "mse", vector of the Mean Squared Error (MSE) for each out-of-bag
prediction of the sink and mediators graph nodes.
\item "Yhat", the matrix of continuous predicted values of graph nodes  
(excluding source nodes) based on out-of-bag samples.
}
}
\description{
Predict method for ML objects.
}
\examples{

\donttest{
# Load Amyotrophic Lateral Sclerosis (ALS)
ig<- alsData$graph
data<- alsData$exprs
data<- transformData(data)$data
group<- alsData$group

#...with train-test (0.5-0.5) samples
set.seed(123)
train<- sample(1:nrow(data), 0.5*nrow(data))

start<- Sys.time()
# ... tree
res1<- SEMml(ig, data[train, ], algo="tree")
mse1<- predict(res1, data[-train, ], verbose=TRUE)

# ... rf
res2<- SEMml(ig, data[train, ], algo="rf")
mse2<- predict(res2, data[-train, ], verbose=TRUE)

# ... xgb
res3<- SEMml(ig, data[train, ], algo="xgb")
mse3<- predict(res3, data[-train, ], verbose=TRUE)

# ... nn
res4<- SEMml(ig, data[train, ], algo="nn")
mse4<- predict(res4, data[-train, ], verbose=TRUE)
end<- Sys.time()
print(end-start)

#...with a categorical (as.factor) outcome
outcome <- factor(ifelse(group == 0, "control", "case")); table(outcome) 

res5 <- SEMml(ig, data[train, ], outcome[train], algo="tree")
pred <- predict(res5, data[-train, ], outcome[-train], verbose=TRUE)
yhat <- pred$Yhat[ ,levels(outcome)]; head(yhat)
yobs <- outcome[-train]; head(yobs)
classificationReport(yobs, yhat, verbose=TRUE)$stats
}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
