% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestralID.R
\name{ancestralIdentifyStep}
\alias{ancestralIdentifyStep}
\title{Perform one iteration of ancestral identification.}
\usage{
ancestralIdentifyStep(mixedGraph, unsolvedParents, solvedParents, identifier)
}
\arguments{
\item{mixedGraph}{a \code{\link{MixedGraph}} object representing
the mixed graph.}

\item{unsolvedParents}{a list whose ith index is a vector of all the parents
j of i in G which for which the edge j->i is not yet known to be
generically identifiable.}

\item{solvedParents}{the complement of \code{unsolvedParents}, a list whose
ith index is a vector of all parents j of i for which the edge i->j
is known to be generically identifiable (perhaps by other algorithms).}

\item{identifier}{an identification function that must produce the
       identifications corresponding to those in solved parents. That is
       \code{identifier} should be a function taking a single argument Sigma
       (any generically generated covariance matrix corresponding
       to the mixed graph) and returns a list with two named arguments
\describe{
  \item{Lambda}{denote the number of nodes in \code{mixedGraph} as n. Then
                Lambda is an nxn matrix whose i,jth entry
\enumerate{
  \item equals 0 if i is not a parent of j,
  \item equals NA if i is a parent of j but \code{identifier} cannot
        identify it generically,
  \item equals the (generically) unique value corresponding to the weight
        along the edge i->j that was used to produce Sigma.
}}
  \item{Omega}{just as Lambda but for the bidirected edges in the mixed
               graph}
}
       such that if j is in \code{solvedParents[[i]]} we must have that
       Lambda[j,i] is not NA.}
}
\value{
a list
}
\description{
A function that does one step through all the nodes in a mixed graph
and tries to determine if directed edge coefficients are generically
identifiable by leveraging decomposition by ancestral subsets. See
algorithm 1 of Drton and Weihs (2015); this version of the algorithm
is somewhat different from Drton and Weihs (2015) in that it also works
on cyclic graphs.
}
\references{
{Drton}, M. and {Weihs}, L. (2015) Generic Identifiability of Linear
Structural Equation Models by Ancestor Decomposition. arXiv 1504.02992
}
