% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfhtcID.R
\name{createLFIdentifierBaseCase}
\alias{createLFIdentifierBaseCase}
\title{Create an latent identifier base case}
\usage{
createLFIdentifierBaseCase(graph)
}
\arguments{
\item{graph}{a \code{\link{LatentDigraph}} object representing
the latent-factor graph. All latent nodes in this graph should be
source nodes (i.e. have no parents).}
}
\value{
a function that takes as input a covariance matrix compatible with
        the latent digraph defined by L and returns a list with two
        named components:
        \describe{
        \item{\code{Lambda}}{a matrix equal to the observed part of L but with NA values
        instead of 1s}
        \item{\code{Omega}}{a matrix equal to O but with NA values for coefficients
        not equal to zero.}
        }
        When building more complex identifiers these NAs will be replaced
        by the value that can be identified from Sigma.
}
\description{
Identifiers are functions that take as input a covariance matrix Sigma
corresponding to some latent digraph G and, from that covariance matrix,
identify some subset of the coefficients in the latent digraph G. This function
takes as input the matrix L defining G and creates an identifier
that does not identify any of the coefficients of G. This is useful as a
base case when building more complex identification functions.
}
