% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trekSepId.R
\name{trekSeparationIdentifyStep}
\alias{trekSeparationIdentifyStep}
\title{Perform one iteration of trek separation identification.}
\usage{
trekSeparationIdentifyStep(mixedGraph, unsolvedParents, solvedParents,
  identifier, maxSubsetSize = 3)
}
\arguments{
\item{mixedGraph}{a \code{\link{MixedGraph}} object representing
the mixed graph.}

\item{unsolvedParents}{a list whose ith index is a vector of all the parents
j of i in G which for which the edge j->i is not yet known to be
generically identifiable.}

\item{solvedParents}{the complement of \code{unsolvedParents}, a list whose
ith index is a vector of all parents j of i for which the edge i->j
is known to be generically identifiable (perhaps by other algorithms).}

\item{identifier}{an identification function that must produce the
       identifications corresponding to those in solved parents. That is
       \code{identifier} should be a function taking a single argument Sigma
       (any generically generated covariance matrix corresponding
       to the mixed graph) and returns a list with two named arguments
\describe{
  \item{Lambda}{denote the number of nodes in \code{mixedGraph} as n. Then
                Lambda is an nxn matrix whose i,jth entry
\enumerate{
  \item equals 0 if i is not a parent of j,
  \item equals NA if i is a parent of j but \code{identifier} cannot
        identify it generically,
  \item equals the (generically) unique value corresponding to the weight
        along the edge i->j that was used to produce Sigma.
}}
  \item{Omega}{just as Lambda but for the bidirected edges in the mixed
               graph}
}
       such that if j is in \code{solvedParents[[i]]} we must have that
       Lambda[j,i] is not NA.}

\item{maxSubsetSize}{a positive integer which controls the maximum subset
size considered in the trek-separation identification
algorithm. Making this parameter smaller means the
algorithm will be faster but less exhaustive (and hence
less powerful).}
}
\value{
see the return of \code{\link{htcIdentifyStep}}.
}
\description{
A function that does one step through all the nodes in a mixed graph
and tries to identify new edge coefficients using trek-separation as
described in Weihs, Robeva, Robinson, et al. (2017).
}
