% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/toxicIntensity.R
\docType{methods}
\name{toxicIntensity}
\alias{toxicIntensity}
\alias{toxicIntensity,Landscape-method}
\title{Method toxicIntensity}
\usage{
toxicIntensity(objectL, ...)

\S4method{toxicIntensity}{Landscape}(objectL, toxic_emission, mintime = 1,
  maxtime = 60, size_raster = 2^10, kernel = "NIG",
  kernel.options = list(h = 2, mu = 2, theta = 0, gamma = -2.59),
  beta = 0.4, alpha = list(minalpha = 0.1, maxalpha = 0.95,
  covariate_threshold = 30, simulate = T, covariate = NULL))
}
\arguments{
\item{objectL}{A Landscape object}

\item{...}{parameters}

\item{toxic_emission}{Matrix of sources emissions, row as sources ID, col as time}

\item{mintime}{Start simulation time (default=1)}

\item{maxtime}{End simulation time}

\item{size_raster}{raster size (default = 2^10)}

\item{kernel}{dispersion kernel, function name (default=NIG)}

\item{kernel.options}{kernel function parameters}

\item{beta}{toxic adherence parameter between 0 and 1 included}

\item{alpha}{list of loss options}
}
\value{
A 3D array as time matrix dispertion, [t,x,y]
}
\description{
Simulate contaminants intensity over the landscape.
}
\details{
The dispersal of contaminants is implemented by rastering the landscape and by computing the convolution.

Local intensity depends of beta and alpha parameters.
}

