% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWD-class.R
\docType{class}
\name{SWD-class}
\alias{SWD-class}
\alias{SWD}
\alias{show,SWD-method}
\title{Sample With Data}
\usage{
\S4method{show}{SWD}(object)
}
\arguments{
\item{object}{SWD object}
}
\description{
Object similar to the MaxEnt SWD format that hosts the species name, the
coordinates of the locations and the value of the environmental variables at
the location places.
}
\details{
The object can contains presence/absence, presence/background,
presence only or absence/background only data. Use the \link{prepareSWD}
function to create the object.
}
\section{Slots}{

\describe{
\item{\code{species}}{character. Name of the species.}

\item{\code{coords}}{data.frame. Coordinates of the locations.}

\item{\code{data}}{data.frame. Value of the environmental variables at location
sites.}

\item{\code{pa}}{numeric. Vector with \code{1} for presence and \code{0} for absence/background
locations.}
}}

\author{
Sergio Vignali
}
