% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{get_W}
\alias{get_W}
\title{Estimation of anchor transformation}
\usage{
get_W(A, gamma, intercept = FALSE, gpu = FALSE)
}
\arguments{
\item{A}{Numerical Anchor of class \code{matrix}.}

\item{gamma}{Strength of distributional robustness, \eqn{\gamma \in [0, \infty]}.}

\item{intercept}{Logical, whether to include an intercept in the anchor.}

\item{gpu}{If \code{TRUE}, the calculations are performed on the GPU. 
If it is properly set up.}
}
\value{
W of class \code{matrix}, the anchor transformation matrix.
}
\description{
Estimates the anchor transformation for the Anchor-Objective. 
The anchor transformation is \eqn{W = I-(1-\sqrt{\gamma}))\Pi_A}, 
where \eqn{\Pi_A = A(A^TA)^{-1}A^T}. For \eqn{\gamma = 1} this is just the identity. 
For \eqn{\gamma = 0} this corresponds to residuals after orthogonal projecting onto A.
For large \eqn{\gamma} this is close to the orthogonal projection onto A, scaled by \eqn{\gamma}.
The estimator \eqn{\text{argmin}_f ||W(Y - f(X))||^2} corresponds to the Anchor-Regression Estimator 
\insertCite{Rothenhausler2021AnchorCausality}{SDModels}, \insertCite{Buhlmann2020InvarianceRobustness}{SDModels}.
}
\examples{
set.seed(1)
n <- 50
X <- matrix(rnorm(n * 1), nrow = n)
Y <- 3 * X + rnorm(n)
W <- get_W(X, gamma = 0)
resid <- W \%*\% Y
}
\references{
\insertAllCited{}
}
\author{
Markus Ulmer
}
