% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_sdg_pattern.R
\name{add_sdg_pattern}
\alias{add_sdg_pattern}
\title{Users Can Add Customized Patterns for Each SDG or Target}
\usage{
add_sdg_pattern(sdg_id, x, operator = "AND", quiet = FALSE)
}
\arguments{
\item{sdg_id}{SDG Goal's ID or Target's ID, in the format of 'SDGx_y', e.g., SDG1_1, SDG2_general}

\item{x}{A vector of strings}

\item{operator}{'AND', 'OR' to combine a vector of keywords for identifying SDG Goals or Targets.}

\item{quiet}{Logical. Suppress info message}
}
\value{
A regerx string
}
\description{
Users Can Add Customized Patterns for Each SDG or Target
}
\examples{
terms_new <- c("improve", "farmer", "income")
add_sdg_pattern(sdg_id = 'SDG1_2', x = terms_new, operator = 'AND')

}
