% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDGdetector.R
\name{SDGdetector}
\alias{SDGdetector}
\title{Identify SDGs in text}
\usage{
SDGdetector(x, col, quiet = FALSE)
}
\arguments{
\item{x}{Data frame or a string}

\item{col}{Column name for text to be assessed}

\item{quiet}{Logical. Suppress info message}
}
\value{
Data frame with the same information as \code{df} and 18 extra columns: 17 columns marking
the number of occurrence of each of the 17 SDGs and one column \code{match_detail} listing
details of specific targets.
}
\description{
Identify 17 Sustainable Development Goals and associated 169 targets in text.
}
\details{
In 2015, leaders worldwide adopted 17 Sustainable Development Goals (SDGs) with 169
targets to be achieved by 2030 (https://sdgs.un.org). The framework of SDGs serves
as a blueprint for shared prosperity for both people and the earth. \code{SDGdetector}
identifies both direct and indirect expressions of SDGs and associated targets in
chunks of text. It takes a data frame with a specified column of text to process as
inputs and outputs a data frame with original columns plus matched SDGs and targets.
}
\examples{
my_col <- c("our goal is to end poverty globally", "this product
contributes to slowing down climate change")
my_text <- data.frame(my_col)
SDGdetector(my_text, my_col)
}
