% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCRSELECT.R
\name{SCRSELECT}
\alias{SCRSELECT}
\title{Performs Bayesian Variable Selection on the covariates in a semi-competing risks model}
\usage{
SCRSELECT(Y1, I1, Y2, I2, X, hyperparameters, beta1start, beta2start,
  beta3start, B, inc, Path, burn)
}
\arguments{
\item{Y1}{Vector Containing non-terminal event times (or censoring time due to death/censoring)}

\item{I1}{Vector Containing non-terminal event indicators (1 if non-terminal event for a patient, 0 otherwise)}

\item{Y2}{Vector Containing Terminal Event times (or censoring)}

\item{I2}{Vector Containing Terminal event indicators (1 if a patients experiences a non-ternminal event, 0 if censored)}

\item{X}{Matrix of Patient Covariates. The last inc will be left out of variable selection.}

\item{hyperparameters}{List containing 29 hyperparameters and four starting values. In order they are: psi-the swap rate of the SVSS algorithm.
c-parameter involved in Sigma matrix for selection. z1a, z1b, z2a, z2b, z3a, z3b - beta hyper parameters on probability of inclusion for each of the three hazard functions.
a1,b1,a2,b2,a3,b3- hyperparameters on sigma_lambda_1, sigma_lambda_2, and sigma_lambda_3.
 clam1, clam2, clam3 - spatial dependency of baseline hazard (between 0 and 1) for the three hazard functions.
  Alpha1, Alpha2, Alpha3 - The parameter for the number of split points in hazards 1,2 and 3 (must be whole number).
  J1max, J2max, J3max - Maximum number of split points allowed (must be whole number).
  J1, J2, J3- Starting number of split points. w, psi1- hyperparameters on theta^{-1}. cep=Tuning Parameter for theta^{-1} sampler.
  epstart-Starting value for theta^{-1}. cl1,cl2,cl3-Tuning parameters for log baseline hazard height sampler.}

\item{beta1start}{Starting Values for Beta1}

\item{beta2start}{Starting Values for Beta2}

\item{beta3start}{Starting Values for Beta3}

\item{B}{Number of iterations}

\item{inc}{Number of variables left out of selection}

\item{Path}{Where to save posterior samples}

\item{burn}{percent of posterior sample to burn in (burn*B must be a whole number)}
}
\value{
Returns marginal posterior probability of inclusion (post burn-in) for each hazard function along with acceptance rates for the various Metropolis-Hastings (and Metropolis-Hastings-Green) samplers.
}
\description{
Performs Bayesian Variable Selection on the covariates in a semi-competing risks model
}
\examples{
####Randomly Generate Semicompeting Risks Data
####Generates random patient time, indicator and covariates.
n=100
Y1=runif(n,0,100)
I1=rbinom(n,1,.5)
Y2=Y1
I2=I1
for(i in 1:n){if(I1[i]==0){Y2[i]=Y1[i]}else{Y2[i]=Y1[i]+runif(1,0,100)}}
I2=rbinom(n,1,.5)
library(mvtnorm)
X=rmvnorm(n,rep(0,7),diag(7))
####Read in Hyperparameters
##Swap Rate
psi=.5
c=5
###Eta Beta function probabilities
z1a=.4
z1b=1.6
z2a=.4
z2b=1.6
z3a=.4
z3b=1.6
####Hierarchical lam params
###Sigma^2 lambda_g hyperparameters
a1=.7
b1=.7
a2=a1
b2=b1
a3=a1
b3=b1
##Spacing dependence c in [0,1]
clam1=1
clam2=1
clam3=1
#####NumSplit
alpha1=3
alpha2=3
alpha3=3
J1max=10
J2max=10
J3max=10
####Split Point Starting Value ###
J1=3
J2=3
J3=3
###epsilon starting values/hyperparameters###
w=.7
psi1=.7
cep=2.4
#############
epstart=1.5
cl1=.25
cl2=.25
cl3=.25
###Beta Starting Values
beta1start=c(1,1,1,1,1,-1,-1)
beta2start=c(1,1,1,1,1,-1,-1)
beta3start=c(-1,1,1,1,1,-1,-1)
hyper1=c(psi,c,z1a,z1b,z2a,z2b,z3a,z3b,a1,b1,a2,b2,a3,b3,clam1,clam2,clam3)
hyper2=c(alpha1,alpha2,alpha3,J1max,J2max,J3max,J1,J2,J3,w,psi1,cep,epstart,cl1,cl2,cl3)
hyper=c(hyper1,hyper2)
###Number of iterations and output location
B=100
Path=tempdir()
###Number of variables to exclude from selection and burnin percent
inc=2
burn=.1
SCRSELECT(Y1,I1,Y2,I2,X,hyper,beta1start,beta2start,beta3start,B,inc,Path,burn)
}
\references{
[1] Lee, K. H., Haneuse, S., Schrag, D. and Dominici, F. (2015), Bayesian semi-parametric analysis of semi-competing risks data: investigating hospital readmission after a pancreatic cancer diagnosis. Journal of the Royal Statistical Society: Series C (Applied Statistics), 64: 253-273. doi: 10.1111/rssc.12078
[2] Chapple, A.C., Vannucci, M., Thall, P.F., Lin, S.(2017), Bayesian Variable selection for a semi-competing risks model with three hazard functions. Journal of Computational Statistics & Data Analysis, Volume 112, August 2017, Pages 170-185
}
