utils::globalVariables(c("P.value", "revDiff", "V2", "finecluster", "rarecluster"))
#' Calculate SCIntRuler
#'
#' @param fullcluster A list of clusters that generated by the function GetCluster()
#' @param seuratlist A list of Seurat objects, usually can be got by SplitObject().
#' @param testres Result from function PermTest()
#' @param p P-value that will be used as the cut-off, default value is 0.1
#'
#' @return SCIntRuler
#' @export
#'
#' @examples
#' \donttest{
#' data(sim_result)
#' data(sim_data_sce)
#' sim_data <- SCEtoSeurat(sim_data_sce)
#' seuratlist <- Seurat::SplitObject(sim_data, split.by = "Study")
#' CalcuSCIR(sim_result[[1]], seuratlist, sim_result[[4]])
#' }

CalcuSCIR <- function(fullcluster, seuratlist, testres, p = 0.1){

  stopifnot(exprs = {
    is.list(fullcluster)
    is.list(seuratlist)
    is.list(testres)
  })


  SCout <- SummCluster(fullcluster)
  refindClust <- SCout$refindClust
  nbroad <- SCout$nbroad
  allrevDiff <- testres$allrevDiff
  allP <- testres$allP


  Sample <- c()
  # for (i in 1:length(allP)){
  #   l <- length(allP[[i]])
  #   ll <- rep(names(seuratlist)[i],l)
  #   Sample <- c(Sample,ll)
  # }

  for (i in seq_along(allP)) {
    l <- length(allP[[i]])
    ll <- rep(names(seuratlist)[i], l)
    Sample <- c(Sample, ll)
  }

  res <- data.frame("P value"=unlist(allP),
                    revDiff = na.omit(c(allrevDiff)), Sample)
  ratio <- dim(subset(res, P.value <= p & revDiff > 0))[1]/length(Sample)

  return(ratio)


}
