% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locks.R
\name{db_locks}
\alias{db_locks}
\alias{lock_table}
\alias{unlock_table}
\title{Sets, queries and removes locks for database tables}
\usage{
lock_table(conn, db_table, schema = NULL)

unlock_table(conn, db_table, schema = NULL, pid = Sys.getpid())
}
\arguments{
\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{db_table}{(\code{character(1)})\cr
A specification of "schema.table" to modify lock for.}

\item{schema}{(\code{character(1)})\cr
The schema where the "locks" table should be created.}

\item{pid}{(\code{numeric(1)})\cr
The process id to remove the lock for.}
}
\value{
\itemize{
\item \code{lock_table()} returns the \code{TRUE} (\code{FALSE}) if the lock was (un)successfully added.
If a lock exists for a non-active process, an error is thrown.
\item \code{unlock_table()} returns \code{NULL} (called for side effects).
}
}
\description{
This set of function adds a simple locking system to database tables.
\itemize{
\item \code{lock_table()} adds a record in the schema.locks table with the current time and R-session process id.
\item \code{unlock_table()} removes records in the schema.locks table with the target table and the R-session process id.
}

When locking a table, the function will check for existing locks on the table and produce an error a lock is held
by a process which no longer exists.
In this case, the lock needs to be removed manually by removing the record from the lock table.
In addition, the error implies that a table may have partial updates that needs to be manually rolled back.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  conn <- DBI::dbConnect(RSQLite::SQLite())

  lock_table(conn, "test_table") # TRUE

  unlock_table(conn, "test_table")

  DBI::dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
