% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logger.R
\name{Logger}
\alias{Logger}
\title{Logger}
\value{
A new instance of the \code{Logger} \link[R6:R6Class]{R6} class.
}
\description{
Create an object for logging database operations
}
\examples{
logger <- Logger$new(db_tablestring = "test.table",
                     ts = "2020-01-01 09:00:00")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{log_path}}{(\code{character(1)})\cr
A directory where log file is written (if this is not NULL). Defaults to \code{getOption("SCDB.log_path")}.}

\item{\code{log_tbl}}{The DB table used for logging. Class is connection-specific, but inherits from \code{tbl_dbi}.}

\item{\code{start_time}}{(\code{POSIXct(1)})\cr
The time at which data processing was started.}

\item{\code{output_to_console}}{(\code{logical(1)})\cr
Should the Logger output to console?
This can always be overridden by Logger$log_info(..., output_to_console = FALSE).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{log_filename}}{\code{character(1)}\cr
The filename (basename) of the file that the \code{Logger} instance will output to}

\item{\code{log_realpath}}{\code{character(1)}\cr
The full path to the logger's log file.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Logger-new}{\code{Logger$new()}}
\item \href{#method-Logger-log_info}{\code{Logger$log_info()}}
\item \href{#method-Logger-log_warn}{\code{Logger$log_warn()}}
\item \href{#method-Logger-log_error}{\code{Logger$log_error()}}
\item \href{#method-Logger-log_to_db}{\code{Logger$log_to_db()}}
\item \href{#method-Logger-clone}{\code{Logger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Logger-new"></a>}}
\if{latex}{\out{\hypertarget{method-Logger-new}{}}}
\subsection{Method \code{new()}}{
Create a new Logger object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$new(
  db_tablestring = NULL,
  log_table_id = getOption("SCDB.log_table_id"),
  log_conn = NULL,
  log_path = getOption("SCDB.log_path"),
  output_to_console = TRUE,
  warn = TRUE,
  ts = NULL,
  start_time = Sys.time()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db_tablestring}}{A string specifying the table being updated}

\item{\code{log_table_id}}{A \code{\link[DBI:Id]{DBI::Id()}} object or a character string readable by \link{id}, specifying the location of the log table.}

\item{\code{log_conn}}{A database connection inheriting from \code{DBIConnection}}

\item{\code{log_path}}{The path where logs are stored.
If NULL, no file logs are created.}

\item{\code{output_to_console}}{Should the Logger output to console (TRUE/FALSE)?}

\item{\code{warn}}{Show a warning if neither log_table_id or log_path could be determined}

\item{\code{ts}}{A timestamp describing the data being processed (not the current time)}

\item{\code{start_time}}{The time at which data processing was started (defaults to \code{\link[=Sys.time]{Sys.time()}})}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Logger-log_info"></a>}}
\if{latex}{\out{\hypertarget{method-Logger-log_info}{}}}
\subsection{Method \code{log_info()}}{
Write a line to log file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$log_info(
  ...,
  tic = Sys.time(),
  output_to_console = self$output_to_console,
  log_type = "INFO"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{One or more character strings to be concatenated}

\item{\code{tic}}{The timestamp used by the log entry (default Sys.time())}

\item{\code{output_to_console}}{Should the line be written to console?}

\item{\code{log_type}}{A character string which describes the severity of the log message}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Logger-log_warn"></a>}}
\if{latex}{\out{\hypertarget{method-Logger-log_warn}{}}}
\subsection{Method \code{log_warn()}}{
Write a warning to log file and generate warning.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$log_warn(..., log_type = "WARNING")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{One or more character strings to be concatenated}

\item{\code{log_type}}{A character string which describes the severity of the log message}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Logger-log_error"></a>}}
\if{latex}{\out{\hypertarget{method-Logger-log_error}{}}}
\subsection{Method \code{log_error()}}{
Write an error to log file and stop execution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$log_error(..., log_type = "ERROR")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{One or more character strings to be concatenated}

\item{\code{log_type}}{A character string which describes the severity of the log message}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Logger-log_to_db"></a>}}
\if{latex}{\out{\hypertarget{method-Logger-log_to_db}{}}}
\subsection{Method \code{log_to_db()}}{
Write or update log table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$log_to_db(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Name-value pairs with which to update the log table}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Logger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Logger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Logger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
