% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_auxiliary.R
\name{plot_SR}
\alias{plot_SR}
\title{Plot stock-recruitment function}
\usage{
plot_SR(
  Spawners,
  expectedR,
  R0 = NULL,
  S0 = NULL,
  rec_dev = NULL,
  trajectory = FALSE,
  y_zoom = NULL,
  ylab = "Recruitment"
)
}
\arguments{
\item{Spawners}{A vector of the number of the spawners (x-axis).}

\item{expectedR}{A vector of the expected recruitment (from the
stock-recruit function) corresponding to values of \code{Spawners}.}

\item{R0}{Virgin recruitment.}

\item{S0}{Virgin spawners.}

\item{rec_dev}{If recruitment deviations are estimated, a vector of estimated recruitment
(in normal space) corresponding to values of \code{Spawners}.}

\item{trajectory}{Indicates whether arrows will be drawn showing the trajectory of
spawners and recruitment deviations over time.}

\item{y_zoom}{If recruitment deviations are plotted, the y-axis limit relative to
maximum expected recruitment \code{expectedR}. If \code{NULL}, all recruitment values are plotted.}

\item{ylab}{Character string for label on y-axis.}
}
\value{
A stock-recruit plot
}
\description{
Plot stock-recruitment (with recruitment deviations if estimated).
}
\author{
Q. Huynh
}
