% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repairChootinan.R
\name{repairChootinan}
\alias{repairChootinan}
\title{Repair an infeasible solution with the method of Chootinan.}
\usage{
repairChootinan(x, fReal, rbf.model, cobra, checkIt = FALSE, conFunc = NULL)
}
\arguments{
\item{x}{an infeasible solution (vector of length \code{dimension})}

\item{fReal}{a vector of length nconstraint holding the real constraint values at \code{x}}

\item{rbf.model}{the constraint surrogate models}

\item{cobra}{parameter list, we need here
   \describe{
     \item{\code{lower}}{   lower bounds of search region}
     \item{\code{upper}}{   upper bounds of search region}
     \item{\code{ri}}{      a list with all parameters for \code{repairChootinan}  }
   }}

\item{checkIt}{[FALSE] if TRUE, perform a check whether the returned solution is really
                    feasible. Needs access to the true constraint function \code{conFunc}}

\item{conFunc}{[NULL] function returning real constraint vector (needed if \code{checkIt==T})}
}
\value{
\code{z},  a vector with a repaired (hopefully feasible) solution
}
\description{
Implements the method of [Choo2006] Chootinan & Chen "Constraint handling in genetic algorithms
 using a gradient-based repair method", Computers & Operations Research 33 (2006), p. 2263.
}
\author{
Wolfgang Konen, Cologne Univeristy of Applied Sciences
}
\seealso{
\code{\link{repairInfeasRI2}}, \code{\link{cobraPhaseII}}
}

