## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ---- message=FALSE------------------------------------------------------
library(Ryacas0)

## ------------------------------------------------------------------------
N <- 3
L1 <- diag(1, 1 + N)
L1[cbind(1+(1:N), 1:N)] <- "-alpha"
L1s <- as.Sym(L1)
L1s

## ------------------------------------------------------------------------
L1s <- as.Sym(L1)
L1s

## ------------------------------------------------------------------------
L1s + 4
tmp <- L1s^4
tmp
Simplify(tmp)

## ------------------------------------------------------------------------
K1s <- Simplify(L1s * Transpose(L1s))
K1s

## ------------------------------------------------------------------------
TeXForm(K1s)

## ---- results="asis"-----------------------------------------------------
cat("\\[ K_1 = ", TeXForm(K1s), " \\]", sep = "")

## ------------------------------------------------------------------------
x <- paste0("x", 1:2)
xs <- as.Sym(x)
xs

## ------------------------------------------------------------------------
A <- matrix(paste0(paste0("a", 1:2), rep(1:2, each = 2)), 2, 2)
As <- as.Sym(A)
As

## ------------------------------------------------------------------------
As*xs
As*As

## ------------------------------------------------------------------------
xs
Eval(xs, list(x1 = 2, x2 = 3))

## ------------------------------------------------------------------------
As
Eval(As, list(a11 = 11, a12 = 12, a21 = 21, a22 = 22))

## ------------------------------------------------------------------------
Ryacas_options("module_matvec_enabled")
As
Ryacas_options(module_matvec_enabled = FALSE)
As

