% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gammapInv}
\alias{gammapInv}
\alias{gammapInva}
\title{gammapInv and gammapInva:  Inverses of normalized gammap function}
\usage{
gammapInv(a, p)

gammapInva(x, p)
}
\arguments{
\item{a}{The numeric 'a' parameter in the upper
incomplete gamma}

\item{p}{The numeric 'p' parameter in the upper incomplete gamma}

\item{x}{The numeric 'x' parameter in the upper incomplete gamma}
}
\value{
inverse gammap results
}
\description{
gammapInv and gammapInva:  Inverses of normalized gammap function
}
\details{
With the equation:

p = gammap(a, x)

The 'gammapInv' function returns a value 'x' that satisfies the
equation above

The 'gammapInva' function returns a value 'q' that satisfies the
equation above

NOTE: gammapInva is slow
}
\examples{

gammapInv(1:3,0.5)

gammapInv(1,1:3/3.1)

gammapInv(1:3,1:3/3.1)

gammapInva(1:3,1:3/3.1)

}
\author{
Matthew L. Fidler
}
