% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss_time_series.R
\name{wtss_to_zoo}
\alias{wtss_to_zoo}
\title{Export data to be used to the zoo format}
\usage{
wtss_to_zoo(data, band = NULL)
}
\arguments{
\item{data}{A tibble with time series.}

\item{band}{Name of the band to be exported 
(if NULL all bands are exported).}
}
\value{
List of time series in zoo format.
}
\description{
Converts data from a tibble to a list of a zoo series.
}
\examples{
\dontrun{
# retrieve a time series
wtss_service <- "https://brazildatacube.dpi.inpe.br/wtss/"
ts_wtss  <- Rwtss::time_series(
                 wtss_service,
                 "MOD13Q1-6", 
                 c("NDVI","EVI"),
                 longitude = -45.00, 
                 latitude  = -12.00,
                 start_date = "2000-02-18", 
                 end_date = "2016-12-18",
                 token = "YOUR-BDC-TOKEN")
# convert to zoo
zoo.lst <- Rwtss::wtss_to_zoo(ts_wtss)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
