% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgCreateKD.r
\name{vcgClostOnKDtreeFromBarycenters}
\alias{vcgClostOnKDtreeFromBarycenters}
\title{search a KD-tree from Barycenters for multiple closest point searches on a mesh}
\usage{
vcgClostOnKDtreeFromBarycenters(x, query, k = 50, sign = TRUE,
  barycentric = FALSE, borderchk = FALSE, angdev = NULL,
  weightnorm = FALSE, facenormals = FALSE, threads = 1)
}
\arguments{
\item{x}{object of class "vcgKDtreeWithBarycenters"}

\item{query}{matrix or triangular mesh containing coordinates}

\item{k}{integer: check the kdtree for the\code{k} closest faces (using faces' barycenters).}

\item{sign}{logical: if TRUE, signed distances are returned.}

\item{barycentric}{logical: if TRUE, barycentric coordinates of the hit
points are returned.}

\item{borderchk}{logical: request checking if the hit face is at the border of the mesh.}

\item{angdev}{maximum deviation between reference and target normals. If the none of the k closest triangles match this criterion, the closest point on the closest triangle is returned but the corresponding distance in $quality is set to 1e5.}

\item{weightnorm}{logical if angdev is set, this requests the normal of the closest points to be estimated by weighting the surrounding vertex normals. Otherwise, simply the hit face's normal is used (faster but slightly less accurate)}

\item{facenormals}{logical: if TRUE only the facenormal of the face the closest point has hit is returned, the weighted average of the surrounding vertex normals otherwise.}

\item{threads}{integer: threads to use in closest point search.}
}
\value{
returns an object of class "mesh3d" with:
\item{vb }{4 x n matrix containing n vertices as homolougous coordinates.}
\item{normals }{4 x n matrix containing vertex normals.}
\item{quality }{numeric vector containing distances to target.}
\item{it }{3 x m integer matrix containing vertex indices forming triangular
faces.Only available, when x is a mesh.}
\item{border }{integer vector of length n: if borderchk = TRUE, for each clostest point the value will be 1 if the hit face is at the border of the target mesh and 0 otherwise.} 
\item{barycoords }{3 x m Matrix containing barycentric coordinates of
closest points; only available if barycentric=TRUE.}
}
\description{
search a KD-tree from Barycenters for multiple closest point searches on a mesh
}
\author{
Stefan Schlager
}
\seealso{
\code{\link{vcgCreateKDtreeFromBarycenters}, \link{vcgSearchKDtree},  \link{vcgCreateKDtree}}
}

