% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaNanRunningVariance}
\alias{tsEvaNanRunningVariance}
\title{Calculate the running variance of a time series with NaN handling}
\usage{
tsEvaNanRunningVariance(series, windowSize)
}
\arguments{
\item{series}{The time series data.}

\item{windowSize}{The size of the window used for calculating the running variance.}
}
\value{
A vector containing the running variance values.
}
\description{
This function calculates the running variance of a time series, taking into account NaN values.
The series must be zero-averaged before passing it to this function.
}
\examples{
series <- c(1,2,NaN,4,5,6,NaN,8,9,4,5,6,7,3,9,1,0,4,5,2)
windowSize <- 3
tsEvaNanRunningVariance(series, windowSize)

}
