% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeReturnPeriodsGPD}
\alias{tsEvaComputeReturnPeriodsGPD}
\title{tsEvaComputeReturnPeriodsGPD}
\usage{
tsEvaComputeReturnPeriodsGPD(
  epsilon,
  sigma,
  threshold,
  peaks,
  nPeaks,
  peaksID,
  sampleTimeHorizon
)
}
\arguments{
\item{epsilon}{The shape parameter of the GPD.}

\item{sigma}{The scale parameter of the GPD.}

\item{threshold}{The threshold value for the GPD.}

\item{peaks}{A vector containing the peak values.}

\item{nPeaks}{The number of peak values.}

\item{peaksID}{An identifier for each peak value.}

\item{sampleTimeHorizon}{The time horizon of the sample.}
}
\value{
A list containing the following components:
\describe{
\item{\code{GpdPseudo}}{A matrix of pseudo observations obtained from
the GPD for each peak value at every time step.}
\item{\code{returnPeriods}}{A matrix of return periods
corresponding to the pseudo observations.}
\item{\code{PseudoObs}}{A data frame containing the pseudo
observations and their corresponding identifiers.}
}
}
\description{
\code{tsEvaComputeReturnPeriodsGPD}is a function that computes the return
periods of a set of observations (peaks) for a
Generalized Pareto Distribution (GPD), given the GPD parameters,
threshold, peaks data, and sample time horizon.
}
\examples{
# Example usage with some sample data
epsilon <- 0.1
sigma <- 2.2
threshold <- 1.3
peaks <- c(10, 20, 30, 40, 50)
nPeaks=5
peaksID=c(230,550,999,1540,3012)
SampleTimeHorizon = 70

results <- tsEvaComputeReturnPeriodsGPD(epsilon, sigma, threshold, peaks,
nPeaks, peaksID, SampleTimeHorizon)
head(results$GpdPseudo)
head(results$returnPeriods)
head(results$PseudoObs)
}
\seealso{
\code{\link{empdis}}
}
