% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{filterData}
\alias{filterData}
\title{Run filter on any StoX related data source}
\usage{
filterData(
  inputData,
  filterExpression,
  propagateDownwards = TRUE,
  propagateUpwards = FALSE
)
}
\arguments{
\item{inputData}{An input data. Can be a list of biotic data (StoX data type \code{\link{BioticData}}), list of acoustic data, StoxBiotic data, or StoxAcoustic data.}

\item{filterExpression}{Filter expression in list of strings. The name of the list and structures should be identical to the names of the input data list.}

\item{propagateDownwards}{Whether the filter action will propagate in the downwards direction. Default to TRUE.}

\item{propagateUpwards}{Whether the filter action will propagate in the upwards direction. Default to FALSE.}
}
\value{
An object of filtered data in the same format as the input data.
}
\description{
Run filter on any StoX related data source
}
