% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotifyOauth.R
\name{spotifyOAuth}
\alias{spotifyOAuth}
\title{Create OAuth token to access Spotify web API}
\usage{
spotifyOAuth(app_id, client_id, client_secret)
}
\arguments{
\item{app_id}{App ID (this is an internal identification for token if you wish to save authorization)}

\item{client_id}{Client ID}

\item{client_secret}{Client Secret}
}
\description{
\code{spotifyOAuth} creates a long-lived OAuth access token that enables R to make
authenticated calls to the Spotify API. The token can be saved as a
file in disk to be re-used in future sessions. This function relies on the
\code{httr} package to create the OAuth token
}
\examples{
\dontrun{

 my_oauth <- spotifyOAuth(app_id="xxxx",client_id="yyyy",client_secret="zzzz")
 save(my_oauth, file="my_oauth")
 load("my_oauth")
 tiago <- getUser(user_id="t.mendesdantas",token=my_oauth)
}


}
