% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_covariance.R
\name{weighted.cov}
\alias{weighted.cov}
\title{Weighted Bivariate Covariance}
\usage{
weighted.cov(x, y, w, na.rm = TRUE)
}
\arguments{
\item{x}{(numeric vector) variable from where to get covariance}

\item{y}{(numeric vector) variable from where to get covariance}

\item{w}{(numeric vector) vector of weights}

\item{na.rm}{(bool) True: NAs be stripped before computation proceeds}
}
\value{
Pearson correlation coefficient
}
\description{
Compute weighted covariance coefficient of two numeric vectors
}
\examples{
data(df_talis18) 

weighted.cov(x = df_talis18$T3STAKE, y = df_talis18$T3TEAM, w = df_talis18$TCHWGT)
}
