% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_management.R
\name{overview_effects}
\alias{overview_effects}
\title{Print effect overview}
\usage{
overview_effects(
  form,
  re = NULL,
  alternatives,
  base = tail(alternatives, 1),
  ordered = FALSE
)
}
\arguments{
\item{form}{A \code{formula} object that is used to specify the model equation.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{alternatives}{A character vector with the names of the choice alternatives.
If not specified, the choice set is defined by the observed choices.
If \code{ordered = TRUE}, \code{alternatives} is assumed to be specified with
the alternatives ordered from worst to best.}

\item{base}{A character, the name of the base alternative for covariates that are not
alternative specific (i.e. type 2 covariates and ASCs). Ignored and set to
\code{NULL} if the model has no alternative specific covariates (e.g. in the
ordered probit model).
Per default, \code{base} is the last element of \code{alternatives}.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}
}
\value{
A data frame, each row is a effect, columns are the effect name
\code{"effect"}, and booleans whether the covariate is alternative-specific
\code{"as_value"}, whether the coefficient is alternative-specific
\code{"as_coef"}, and whether it is a random effect \code{"random"}.
}
\description{
This function gives an overview of the effect names, whether the covariate
is alternative-specific, whether the coefficient is alternative-specific,
and whether it is a random effect.
}
\examples{
overview_effects(
  form = choice ~ price + time + comfort + change | 1,
  re = c("price", "time"),
  alternatives = c("A", "B"),
  base = "A"
)

}
\seealso{
\code{\link[=check_form]{check_form()}} for checking the model formula specification.
}
