% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations.get.files.R
\name{organizations.get.files}
\alias{organizations.get.files}
\title{List files attached to an organization}
\usage{
organizations.get.files(id, start = NULL, limit = NULL,
  include_deleted_files = NULL, sort = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{id}{ID of the organization}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{include_deleted_files}{When enabled, the list of files will also include deleted files. Please note that trying to download these files will not work. This field has the following domains: (0; 1)}

\item{sort}{Field names and sorting mode separated by a comma (field_name_1 ASC, field_name_2 DESC). Only first-level field keys are supported (no nested keys). Supported fields: id, user_id, deal_id, person_id, org_id, product_id, add_time, update_time, file_name, file_type, file_size, comment.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to List files attached to an organization from pipedrive.
}
\examples{
\donttest{
organizations.get.files(id='e.g.',api_token='token',company_domain='exp')
}
}
