% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deals.find.R
\name{deals.find}
\alias{deals.find}
\title{Find deals by name}
\usage{
deals.find(term, person_id = NULL, org_id = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{term}{Search term to look for}

\item{person_id}{ID of the person deal is associated with.}

\item{org_id}{ID of the organization deal is associated with.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Find deals by name from pipedrive.
}
\examples{
\donttest{
deals.find(term='e.g.',api_token='token',company_domain='exp')
}
}
