% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocator.R
\name{robyn_allocator}
\alias{robyn_allocator}
\alias{print.robyn_allocator}
\alias{plot.robyn_allocator}
\title{Budget Allocator}
\usage{
robyn_allocator(
  robyn_object = NULL,
  select_build = 0,
  InputCollect = NULL,
  OutputCollect = NULL,
  select_model = NULL,
  optim_algo = "SLSQP_AUGLAG",
  scenario = "max_historical_response",
  expected_spend = NULL,
  expected_spend_days = NULL,
  channel_constr_low = 0.5,
  channel_constr_up = 2,
  maxeval = 1e+05,
  constr_mode = "eq",
  date_min = NULL,
  date_max = NULL,
  export = TRUE,
  quiet = FALSE,
  ui = FALSE
)

\method{print}{robyn_allocator}(x, ...)

\method{plot}{robyn_allocator}(x, ...)
}
\arguments{
\item{robyn_object}{Character. Path of the \code{Robyn.RDS} object
that contains all previous modeling information.}

\item{select_build}{Integer. Default to the latest model build. \code{select_build = 0}
selects the initial model. \code{select_build = 1} selects the first refresh model.}

\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{OutputCollect}{List. Containing all model result.
Required when \code{robyn_object} is not provided.}

\item{select_model}{Character. A model \code{SolID}. When \code{robyn_object}
is provided, \code{select_model} defaults to the already selected \code{SolID}. When
\code{robyn_object} is not provided, \code{select_model} must be provided with
\code{InputCollect} and \code{OutputCollect}, and must be one of
\code{OutputCollect$allSolutions}.}

\item{optim_algo}{Character. Default to \code{"SLSQP_AUGLAG"}, short for "Sequential Least-Squares
Quadratic Programming" and "Augmented Lagrangian". Alternatively, "\code{"MMA_AUGLAG"},
short for "Methods of Moving Asymptotes". More details see the documentation of
NLopt \href{https://nlopt.readthedocs.io/en/latest/NLopt_Algorithms/}{here}.}

\item{scenario}{Character. Accepted options are: \code{"max_historical_response"} or
\code{"max_response_expected_spend"}. \code{"max_historical_response"} simulates the scenario
"what's the optimal media spend allocation given the same average spend level in history?",
while \code{"max_response_expected_spend"} simulates the scenario "what's the optimal media
spend allocation of a given future spend level for a given period?"}

\item{expected_spend}{Numeric. The expected future spend volume. Only applies when
\code{scenario = "max_response_expected_spend"}.}

\item{expected_spend_days}{Integer. The duration of the future spend volume in
\code{expected_spend}. Only applies when \code{scenario = "max_response_expected_spend"}.}

\item{channel_constr_low, channel_constr_up}{Numeric vector. The lower and upper bounds
for each paid media variable when maximizing total media response. \code{channel_constr_low
= 0.7} means minimum spend of the variable is 70% of historical average. Lower bound must
be >=0.01. \code{channel_constr_up = 1.5} means maximum spend of the variable is 150% of
historical average. Upper bound must be >= lower bound. Both must have same length and order
as \code{paid_media_spends}. nIt's ot recommended to 'exaggerate' upper bounds, esp. if the
new level is way higher than historical level.}

\item{maxeval}{Integer. The maximum iteration of the global optimization algorithm.
Defaults to 100000.}

\item{constr_mode}{Character. Options are \code{"eq"} or \code{"ineq"},
indicating constraints with equality or inequality.}

\item{date_min, date_max}{Character. Date range to calculate mean (of non-zero spends) and
total spends. Default will consider all dates within window. Length must be 1.}

\item{export}{Boolean. Export outcomes into local files?}

\item{quiet}{Boolean. Keep messages off?}

\item{ui}{Boolean. Save additional outputs for UI usage. List outcome.}

\item{x}{\code{robyn_allocator()} output.}

\item{...}{Additional parameters passed to \code{robyn_outputs()}.}
}
\value{
A list object containing allocator result.

List. Contains optimized allocation results and plots.
}
\description{
\code{robyn_allocator()} function returns a new split of media
variable spends that maximizes the total media response.
}
\examples{
\dontrun{
# Having InputCollect and OutputCollect results
# Set your exported model location
robyn_object <- "~/Desktop/MyRobyn.RDS"

# Check media summary for selected model from the simulated data
select_model <- "3_10_3"
OutputCollect$xDecompAgg[
  solID == select_model & !is.na(mean_spend),
  .(rn, coef, mean_spend, mean_response, roi_mean,
    total_spend,
    total_response = xDecompAgg, roi_total, solID
  )
]

# Run allocator with 'InputCollect' and 'OutputCollect'
# with 'scenario = "max_historical_response"'
AllocatorCollect <- robyn_allocator(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  select_model = select_model,
  scenario = "max_historical_response",
  channel_constr_low = c(0.7, 0.7, 0.7, 0.7, 0.7),
  channel_constr_up = c(1.2, 1.5, 1.5, 1.5, 1.5)
)

# Run allocator with a 'robyn_object' from the second model refresh
# with 'scenario = "max_response_expected_spend"'
AllocatorCollect <- robyn_allocator(
  robyn_object = robyn_object,
  select_build = 2,
  scenario = "max_response_expected_spend",
  channel_constr_low = c(0.7, 0.7, 0.7, 0.7, 0.7),
  channel_constr_up = c(1.2, 1.5, 1.5, 1.5, 1.5),
  expected_spend = 100000,
  expected_spend_days = 90
)
}
}
