% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{robyn_clusters}
\alias{robyn_clusters}
\title{Clustering to Reduce Number of Models based on ROI and Errors}
\usage{
robyn_clusters(
  input,
  dep_var_type,
  all_media = NULL,
  k = "auto",
  limit = 1,
  weights = rep(1, 3),
  dim_red = "PCA",
  quiet = FALSE,
  export = FALSE,
  seed = 123,
  ...
)
}
\arguments{
\item{input}{\code{robyn_export()}'s output or \code{pareto_aggregated.csv} results.}

\item{dep_var_type}{Character. For dep_var_type 'revenue', ROI is used for clustering.
For conversion', CPA is used for clustering.}

\item{all_media}{A character vector. Default to \code{InputCollect$all_media}.
Includes \code{InputCollect$paid_media_vars} and \code{InputCollect$organic_vars}.}

\item{k}{Integer. Number of clusters}

\item{limit}{Integer. Top N results per cluster. If kept in "auto", will select k
as the cluster in which the WSS variance was less than 5\%.}

\item{weights}{Vector, size 3. How much should each error weight?
Order: nrmse, decomp.rssd, mape. The highest the value, the closer it will be scaled
to origin. Each value will be normalized so they all sum 1.}

\item{dim_red}{Character. Select dimensionality reduction technique.
Pass any of: \code{c("PCA", "tSNE", "all", "none")}.}

\item{quiet}{Boolean. Keep quiet? If not, print messages.}

\item{export}{Export plots into local files?}

\item{seed}{Numeric. Seed for reproducibility}

\item{...}{Additional parameters passed to \code{lares::clusterKmeans()}.}
}
\value{
List. Clustering results as labeled data.frames and plots.
}
\description{
\code{robyn_clusters()} uses output from \code{robyn_run()},
to reduce the number of models and create bootstrapped confidence
interval and help the user pick up the best (lowest combined error)
of the most different kinds (clusters) of models.
}
\examples{
\dontrun{
# Having InputCollect and OutputCollect results
cls <- robyn_clusters(
  input = OutputCollect,
  all_media = InputCollect$all_media,
  k = 3, limit = 2,
  weights = c(1, 1, 1.5)
)
}
}
\author{
Bernardo Lares (bernardolares@meta.com)
}
