#' Example Trial Data for GLMs with Permute-Block Randomization
#'
#' This dataset contains the trial example data for GLMs with permute block randomization.
#'
#' @format A data frame with 600 rows and 7 columns:
#'   \describe{
#'     \item{id}{The ID of the patients.}
#'     \item{treatment}{The treatment assignment, "pbo", "trt1" and "trt2"}
#'     \item{s1}{The first stratification variable, "a" and "b".}
#'     \item{s2}{The second stratification variable, "c" and "d".}
#'     \item{covar}{The covariate following normal distribution.}
#'     \item{y}{The continuous response.}
#'     \item{y_b}{The binary response.}
#'   }
#'
#' @source The data is generated by the `create_glm_data.R` script.
#'
#' @keywords dataset
"glm_data"

#' Survival Example Data
#'
#' This dataset contains survival data from the `survival`
#' package's [survival::lung] dataset, modified to include factors for
#' `sex` and `strata`, as well as a binary `status` variable which is 1
#' for death and 0 for censored.
#'
#' @source The data is generated by the `create_surv_data.R` script.
#'
#' @keywords dataset
"surv_data"
