% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmrobdet.R
\name{lmrobdet.control}
\alias{lmrobdet.control}
\title{Tuning parameters for lmrobdetMM and lmrobdetDCML}
\usage{
lmrobdet.control(bb = 0.5, efficiency = 0.95, family = "mopt",
  tuning.psi, tuning.chi, compute.rd = FALSE, corr.b = TRUE,
  split.type = "f", initial = "S", max.it = 100,
  refine.tol = 1e-07, rel.tol = 1e-07, refine.PY = 10,
  solve.tol = 1e-07, trace.lev = 0, psc_keep = 0.5,
  resid_keep_method = "threshold", resid_keep_thresh = 2,
  resid_keep_prop = 0.2, py_maxit = 20, py_eps = 1e-05,
  mscale_maxit = 50, mscale_tol = 1e-06, mscale_rho_fun = "bisquare")
}
\arguments{
\item{bb}{tuning constant (between 0 and 1/2) for the M-scale used to compute the initial S-estimator. It
determines the robusness (breakdown point) of the resulting MM-estimator, which is
\code{bb}. Defaults to 0.5.}

\item{efficiency}{desired asymptotic efficiency of the final regression M-estimator. Defaults to 0.95.}

\item{family}{string specifying the name of the family of loss function to be used (current valid
options are "bisquare", "opt" and "mopt"). Incomplete entries will be matched to the current valid options. Defaults to "mopt".}

\item{tuning.psi}{tuning parameters for the regression M-estimator computed with a rho function
as specified with argument \code{family}. If missing, it is computed inside \code{lmrobdet.control} to match
the value of \code{efficiency} according to the family of rho functions specified in \code{family}.
Appropriate values for \code{tuning.psi} for a given desired efficiency for Gaussian errors
can be constructed using the functions \link{bisquare}, \link{mopt} and \link{opt}.}

\item{tuning.chi}{tuning constant for the function used to compute the M-scale
used for the initial S-estimator. If missing, it is computed inside \code{lmrobdet.control} to match
the value of \code{bb} according to the family of rho functions specified in \code{family}.}

\item{compute.rd}{logical value indicating whether robust leverage distances need to be computed.}

\item{corr.b}{logical value indicating whether a finite-sample correction should be applied
to the M-scale parameter \code{bb}.}

\item{split.type}{determines how categorical and continuous variables are split. See
\code{\link[robustbase]{splitFrame}}.}

\item{initial}{string specifying the initial value for the M-step of the MM-estimator. Valid
options are \code{'S'}, for an S-estimator and \code{'MS'} for an M-S estimator which is
appropriate when there are categorical explanatory variables in the model.}

\item{max.it}{maximum number of IRWLS iterations for the MM-estimator}

\item{refine.tol}{relative covergence tolerance for the S-estimator}

\item{rel.tol}{relative covergence tolerance for the IRWLS iterations for the MM-estimator}

\item{refine.PY}{number of refinement steps for the Pen~a-Yohai candidates}

\item{solve.tol}{(for the S algorithm): relative tolerance for matrix inversion. Hence, this corresponds to \code{\link{solve.default}}'s tol.}

\item{trace.lev}{positive values (increasingly) provide details on the progress of the MM-algorithm}

\item{psc_keep}{For \code{pyinit}, proportion of observations to remove based on PSCs. The effective proportion of removed
observations is adjusted according to the sample size to be \code{prosac*(1-p/n)}. See \code{\link{pyinit}}.}

\item{resid_keep_method}{For \code{pyinit}, how to clean the data based on large residuals. If
\code{"threshold"}, all observations with scaled residuals larger than \code{C.res} will
be removed, if \code{"proportion"}, observations with the largest \code{prop} residuals will
be removed. See \code{\link{pyinit}}.}

\item{resid_keep_thresh}{See parameter \code{resid_keep_method} above. See \code{\link{pyinit}}.}

\item{resid_keep_prop}{See parameter \code{resid_keep_method} above. See \code{\link{pyinit}}.}

\item{py_maxit}{Maximum number of iterations. See \code{\link{pyinit}}.}

\item{py_eps}{Relative tolerance for convergence.  See \code{\link{pyinit}}.}

\item{mscale_maxit}{Maximum number of iterations for the M-scale algorithm. See \code{\link{pyinit}} and \code{\link{mscale}}.}

\item{mscale_tol}{Convergence tolerance for the M-scale algorithm. See \code{\link{mscale}} and \code{\link{mscale}}.}

\item{mscale_rho_fun}{String indicating the loss function used for the M-scale. See \code{\link{pyinit}}.}
}
\value{
A list with the necessary tuning parameters.
}
\description{
This function sets tuning parameters for the MM estimator implemented in \code{lmrobdetMM} and
the Distance Constrained Maximum Likelihood regression estimators
computed by \code{lmrobdetDCML}.
}
\details{
The argument \code{family} specifies the name of the family of loss function to be used. Current valid
options are "bisquare", "opt" and "mopt"--"opt" refers to the optimal psi function defined in Section 5.8.1. of the
book Robust Statistics: Theory and Methods (with R) by Maronna, Martin, Yohai and Salibian-Barrera,
"mopt" is a modified  version of the optimal psi function to make it
strictly increasing close to 0, and to make the corresponding weight function
non-increasing near 0.
}
\examples{
data(coleman, package='robustbase')
m2 <- lmrobdetMM(Y ~ ., data=coleman, control=lmrobdet.control(refine.PY=50))
m2
summary(m2)

}
\seealso{
\code{\link{pyinit}}, \code{\link{mscale}}.
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
