# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Noun extractor by mecab-ko
#'
#' \code{nouns} returns nouns extracted from Korean phrases.
#' 
#' Noun extraction is used for many Korean text analysis algorithms.
#'
#' @param phrase Character vector.
#' @return List of nouns will be returned. Element name of the list are original phrases.
#'
#' See examples in \href{https://github.com/junhewk/RmecabKo}{Github}.
#' 
#' @examples 
#' \dontrun{
#' nouns(c("Some Korean Phrases"))
#' }
#' 
#' @export

nouns <- function(phrase) {
  if (typeof(phrase) != "character") {
    stop("'phrase' must be a character vector")
  }
  
  if(is_osx() | is_linux()) {
    
    dicpath <- "/usr/local/lib/mecab/dic/mecab-ko-dic"
    
    if(dir.exists(dicpath)) {
      dicpath <- paste0("-d ", dicpath)
    } else {
      stop(paste0("Mecab-ko-dic is not found on ", dicpath, ". Please check https://bitbucket.org/eunjeon/mecab-ko-dic."))
    }

    # Rcpp function to tagging
    tagged <- nounsRcpp(phrase, dicpath)
    
  } else if(is_windows()) {
    
    if(!mecab_installed()) {
      stop("Mecab binary is not installed in C:\\mecab. Please run install_mecab().")
    }

    mecabLibs <- getOption("mecab.libpath")
    
    # loading /inst/mecab/mecab.exe (mecab-ko-msvc) with system.file and system
    mecabKo <- utils::shortPathName(file.path(mecabLibs, "mecab.exe"))
    mecabKoRc <- utils::shortPathName(file.path(mecabLibs, "mecabrc"))
    # mecabKoDic root in not working
    mecabKoDic <- utils::shortPathName(file.path(mecabLibs, "mecab-ko-dic"))
    
    # saving phrase to UTF-8 txt file
    phraseFile <- utils::shortPathName(tempfile())

    con <- file(phraseFile, "a")
    tryCatch({
      cat(iconv(phrase, to="UTF-8"), file=con, sep="\n")
    },
    finally = {
      close(con)
    })

    outputFile <- utils::shortPathName(tempfile())
    
    mecabOption <- c("-r", mecabKoRc, "-d", mecabKoDic, "-o", outputFile, phraseFile)
    
    # run mecab.exe
    system2(mecabKo, mecabOption)

    con <- file(outputFile, "r")
    posResult <- readLines(con, encoding="UTF-8")
    close(con)
    
    i <- 1
    tagged <- list()
    taggedLine <- c()
    
    for(posLine in posResult) {
      if(posLine=="EOS") {
        if(is.null(taggedLine)) {
          length(tagged) <- i
        } else {
          tagged[[i]] <- taggedLine
        }
        i <- i + 1
        taggedLine <- c()
      } else {
        taggedElements <- strsplit(posLine, "\t")
        if(substring(taggedElements[[1]][2], 1, 1) == "N") {
          taggedLine <- c(taggedLine, taggedElements[[1]][1])
        }
      }
    }
    
    suppressWarnings(file.remove(phraseFile))
    suppressWarnings(file.remove(outputFile))
  } 
  names(tagged) <- phrase
  return(tagged)
}
