% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magic.R
\name{ggplot.magic}
\alias{ggplot.magic}
\title{Convert a MAGIC object to a data.frame for ggplot}
\usage{
\method{ggplot}{magic}(data, ...)
}
\arguments{
\item{data}{A fitted MAGIC object}

\item{...}{Arguments for ggplot()}
}
\description{
Passes the smoothed data matrix to ggplot
}
\examples{
if (reticulate::py_module_available("magic") && require(ggplot2)) {

data(magic_testdata)
data_magic <- magic(magic_testdata, genes=c("VIM", "CDH1", "ZEB1"))
ggplot(data_magic, aes(VIM, CDH1, colour=ZEB1)) +
  geom_point()

}
}
