% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimation.R
\name{maxim.integrand}
\alias{maxim.integrand}
\title{Maximization of the Integrand for Generalized Linear Gaussian Process Models}
\usage{
maxim.integrand(
  y,
  units_m,
  mu,
  Sigma,
  ID_coords,
  ID_re = NULL,
  family,
  sigma2_re = NULL,
  hessian = FALSE,
  gradient = FALSE
)
}
\arguments{
\item{y}{Response variable vector.}

\item{units_m}{Units of measurement for the response variable.}

\item{mu}{Mean vector of the response variable.}

\item{Sigma}{Covariance matrix of the spatial process.}

\item{ID_coords}{Indices mapping response to locations.}

\item{ID_re}{Indices mapping response to unstructured random effects.}

\item{family}{Distribution family for the response variable. Must be one of 'gaussian', 'binomial', or 'poisson'.}

\item{sigma2_re}{Variance of the unstructured random effects.}

\item{hessian}{Logical; if TRUE, compute the Hessian matrix.}

\item{gradient}{Logical; if TRUE, compute the gradient vector.}
}
\value{
A list containing the mode estimate, and optionally, the Hessian matrix and gradient vector.
}
\description{
Maximizes the integrand function for Generalized Linear Gaussian Process Models (GLGPMs), which involves the evaluation of likelihood functions with spatially correlated random effects.
}
\details{
This function maximizes the integrand for GLGPMs using the Nelder-Mead optimization algorithm. It computes the likelihood function incorporating spatial covariance and unstructured random effects, if provided.

The integrand includes terms for the spatial process (Sigma), unstructured random effects (sigma2_re), and the likelihood function (llik) based on the specified distribution family ('gaussian', 'binomial', or 'poisson').
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
