% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IEX_Market_Data.R
\name{iex.company}
\alias{iex.company}
\title{Returns company's key info. For example: Industry, CEO, website, number of employees, ..etc.}
\usage{
iex.company(x = "TSLA", iex_sk)
}
\arguments{
\item{x}{A charcter vector that can include one or multiple  Tickers / Stocks Symbols}

\item{iex_sk}{is a character vector that include IEX Cloud API Secret Token}
}
\value{
data frame with company summary data
}
\description{
For more details, visit:\url{https://iexcloud.io/docs/api/#company}
}
\examples{
\donttest{
  iex.company("TSLA")
}
}
\seealso{
Investors Exchange `IEX` developer guide \url{https://iexcloud.io/docs/api/}

Investors Exchange Group (IEX Group) offers flexible and salable pricing.\url{https://iexcloud.io/pricing/}

View Investors Exchange Group (IEX Group) terms of use and subscription levels.\url{https://iexcloud.io/terms/}

Package `iexcloudR`\url{https://github.com/schardtbc/iexcloudR}
}
\author{
Myriam Ibrahim
}
