% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcor.r
\name{fwcor}
\alias{fwcor}
\title{Weighted Correlation Matrix}
\usage{
fwcor(U, groups)
}
\arguments{
\item{U}{An object of class \code{\link{fssa}}.}

\item{groups}{A list or vector of indices which determines the grouping used for the reconstruction
in pairwise w-correlations matrix.}
}
\value{
A square matrix of w-correlation values for the reconstructed \code{\link{fts}} objects that were built from.
\code{\link{fssa}} components
}
\description{
This function returns the weighted correlation (w-correlation) matrix for functional time series (\code{\link{fts}}) objects
that were reconstructed from functional singular spectrum analysis (\code{\link{fssa}}) objects.
}
\examples{
\dontrun{

## Univariate FSSA Example on Callcenter data
require(Rfssa)
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Callcenter.RData")
## Define functional objects
D <- matrix(sqrt(Callcenter$calls), nrow = 240)
N <- ncol(D)
time <- substr(seq(ISOdate(1999, 1, 1), ISOdate(1999, 12, 31), by = "day"),1,10)
K <- nrow(D)
u <- seq(0, K, length.out = K)
d <- 22 # Optimal Number of basis elements
## Define functional time series
Y <- Rfssa::fts(list(D), list(list(d, "bspline")), list(u),time)
Y
plot(Y, mains = c("Sqrt of Call Center Data"))
## Univariate functional singular spectrum analysis
L <- 28
U <- fssa(Y, L)
ufwcor <- fwcor(U = U, groups = list(1, 2, 3))
wplot(W = ufwcor)

## Multivariate W-Correlation Example on Bivariate Satelite Image Data
require(Rfssa)
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Jambi.RData")
## Raw image data
NDVI <- Jambi$NDVI
EVI <- Jambi$EVI
time <- Jambi$Date
## Kernel density estimation of pixel intensity
D0_NDVI <- matrix(NA, nrow = 512, ncol = 448)
D0_EVI <- matrix(NA, nrow = 512, ncol = 448)
for (i in 1:448) {
  D0_NDVI[, i] <- density(NDVI[, , i], from = 0, to = 1)$y
  D0_EVI[, i] <- density(EVI[, , i], from = 0, to = 1)$y
}
## Define functional objects
d <- 11
D <- list(D0_NDVI, D0_EVI)
B <- list(list(d, "bspline"), list(d + 4, "fourier"))
U <- list(c(0, 1), c(0, 1))
Y <- Rfssa::fts(D, B, U, time)
plot(Y)
U <- fssa(Y = Y, L = 45)
L <- 45
mfwcor <- fwcor(U = U, groups = list(1, 2, 3, 4))
wplot(W = mfwcor)
}

}
\seealso{
\code{\link{fssa}}, \code{\link{freconstruct}}, \code{\link{fts}}, \code{\link{wplot}}
}
