% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PooledConnectionHandler.R
\name{PooledConnectionHandler}
\alias{PooledConnectionHandler}
\title{Pooled Connection Handler}
\description{
Transparently works the same way as a standard connection handler but stores pooled connections.
Useful for long running applications that serve multiple concurrent requests.
}
\section{Super class}{
\code{\link[ResultModelManager:ConnectionHandler]{ResultModelManager::ConnectionHandler}} -> \code{PooledConnectionHandler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PooledConnectionHandler-new}{\code{PooledConnectionHandler$new()}}
\item \href{#method-PooledConnectionHandler-initConnection}{\code{PooledConnectionHandler$initConnection()}}
\item \href{#method-PooledConnectionHandler-getConnection}{\code{PooledConnectionHandler$getConnection()}}
\item \href{#method-PooledConnectionHandler-dbms}{\code{PooledConnectionHandler$dbms()}}
\item \href{#method-PooledConnectionHandler-closeConnection}{\code{PooledConnectionHandler$closeConnection()}}
\item \href{#method-PooledConnectionHandler-queryFunction}{\code{PooledConnectionHandler$queryFunction()}}
\item \href{#method-PooledConnectionHandler-executeFunction}{\code{PooledConnectionHandler$executeFunction()}}
\item \href{#method-PooledConnectionHandler-clone}{\code{PooledConnectionHandler$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ResultModelManager" data-topic="ConnectionHandler" data-id="dbIsValid"><a href='../../ResultModelManager/html/ConnectionHandler.html#method-ConnectionHandler-dbIsValid'><code>ResultModelManager::ConnectionHandler$dbIsValid()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ResultModelManager" data-topic="ConnectionHandler" data-id="executeSql"><a href='../../ResultModelManager/html/ConnectionHandler.html#method-ConnectionHandler-executeSql'><code>ResultModelManager::ConnectionHandler$executeSql()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ResultModelManager" data-topic="ConnectionHandler" data-id="finalize"><a href='../../ResultModelManager/html/ConnectionHandler.html#method-ConnectionHandler-finalize'><code>ResultModelManager::ConnectionHandler$finalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ResultModelManager" data-topic="ConnectionHandler" data-id="queryDb"><a href='../../ResultModelManager/html/ConnectionHandler.html#method-ConnectionHandler-queryDb'><code>ResultModelManager::ConnectionHandler$queryDb()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ResultModelManager" data-topic="ConnectionHandler" data-id="renderTranslateSql"><a href='../../ResultModelManager/html/ConnectionHandler.html#method-ConnectionHandler-renderTranslateSql'><code>ResultModelManager::ConnectionHandler$renderTranslateSql()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ResultModelManager" data-topic="ConnectionHandler" data-id="tbl"><a href='../../ResultModelManager/html/ConnectionHandler.html#method-ConnectionHandler-tbl'><code>ResultModelManager::ConnectionHandler$tbl()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-new"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$new(
  connectionDetails = NULL,
  snakeCaseToCamelCase = TRUE,
  loadConnection = TRUE,
  dbConnectArgs = NULL,
  forceJdbcConnection = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{connectionDetails}}{DatabaseConnector::connectionDetails class}

\item{\code{snakeCaseToCamelCase}}{(Optional) Boolean. return the results columns in camel case (default)}

\item{\code{loadConnection}}{Boolean option to load connection right away}

\item{\code{dbConnectArgs}}{Optional arguments to call pool::dbPool overrides default usage of connectionDetails}

\item{\code{forceJdbcConnection}}{Force JDBC connection (requires using DatabaseConnector ConnectionDetails)
initialize pooled db connection}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-initConnection"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-initConnection}{}}}
\subsection{Method \code{initConnection()}}{
Overrides ConnectionHandler Call
Get Connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$initConnection()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-getConnection"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-getConnection}{}}}
\subsection{Method \code{getConnection()}}{
Returns a connection from the pool
When the desired frame exits, the connection will be returned to the pool
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$getConnection(.deferedFrame = parent.frame(n = 2))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{.deferedFrame}}{defaults to the parent frame of the calling block.
get dbms}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-dbms"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-dbms}{}}}
\subsection{Method \code{dbms()}}{
Get the dbms type of the connection
Close Connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$dbms()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-closeConnection"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-closeConnection}{}}}
\subsection{Method \code{closeConnection()}}{
Overrides ConnectionHandler Call
query Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$closeConnection()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-queryFunction"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-queryFunction}{}}}
\subsection{Method \code{queryFunction()}}{
Overrides ConnectionHandler Call. Does not translate or render sql.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$queryFunction(
  sql,
  snakeCaseToCamelCase = self$snakeCaseToCamelCase
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql}}{sql query string}

\item{\code{snakeCaseToCamelCase}}{(Optional) Boolean. return the results columns in camel case (default)
query Function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-executeFunction"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-executeFunction}{}}}
\subsection{Method \code{executeFunction()}}{
Overrides ConnectionHandler Call. Does not translate or render sql.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$executeFunction(sql)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql}}{sql query string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PooledConnectionHandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PooledConnectionHandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PooledConnectionHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
